function tf = ispcx(filename)
%ISPCX Returns true for a PCX file.
%   TF = ISPCX(FILENAME)

%   Copyright 1984-2002 The MathWorks, Inc.
%   $Revision: 1.2 $  $Date: 2002/06/05 20:09:31 $

fid = fopen(filename, 'r', 'ieee-le');
if (fid < 0)
    tf = false;
else
    header = fread(fid, 128, 'uint8');
    fclose(fid);
    if (length(header) < 128)
        tf = false;
    else
        tf = (header(1) == 10) & ismember(header(2), [0 2 3 4 5]);
    end
end
