function data = hdfraster24read(hinfo)
%HDFRASTER24READ
%
%   DATA = HDFRASTER24READ(HINFO) returns in the variable DATA the image
%   from the file for the particular 24-bit raster image described by HINFO.
%   HINFO is A structure extraced from the output structure of HDFINFO.

%   Copyright 1984-2002 The MathWorks, Inc. 
%   $Revision: 1.3 $  $Date: 2002/06/05 20:09:00 $

data = [];

parseInputs(hinfo);
try
  status = hdfdf24('readref',hinfo.Filename,hinfo.Ref);
  hdfwarn(status)

  [data, status] = hdfdf24('getimage',hinfo.Filename);
  hdfwarn(status)
catch
  warning(lasterr)
end
status = hdfdf24('restart');
hdfwarn(status)
%Put the image data in the right order for image display in MATLAB
data = permute(data,[3 2 1]);
return;

%=======================================================================
function parseInputs(hinfo,varargin)

error(nargchk(1,1,nargin));
	  
%Verify required fields
msg = 'Invalid input arguments.  HINFO must be a structure with fields ''Filename'', and ''Ref''.  Consider using HDFIFNO to obtain this structure.';

if ~isstruct(hinfo)
  error(msg);
end
fNames = fieldnames(hinfo);
numFields = length(fNames);
reqFields = {'Filename','Ref'};
numReqFields = length(reqFields);
if numFields >= numReqFields
  for i=1:numReqFields
    if ~isfield(hinfo,reqFields{i})
      error(msg);
    end
  end
else 
  error(msg);
end
return;

