/*
 * MATLAB Compiler: 3.0
 * Date: Mon Sep 20 09:40:15 2004
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-B" "sgl" "-m" "-W"
 * "main" "-L" "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "-W" "mainhg"
 * "libmwsglm.mlib" "recarga_multiple" 
 */
#include "stormcheck.h"
#include "eventinfo.h"
#include "libmatlbm.h"
static mxArray * _mxarray0_;
static mxArray * _mxarray1_;
static mxArray * _mxarray2_;
static mxArray * _mxarray3_;
static mxArray * _mxarray4_;

void InitializeModule_stormcheck(void) {
    _mxarray0_ = mclInitializeDouble(1.0);
    _mxarray1_ = mclInitializeDouble(3.0);
    _mxarray2_ = mclInitializeDouble(0.0);
    _mxarray3_ = mclInitializeDouble(2.0);
    _mxarray4_ = mclInitializeDoubleVector(0, 0, (double *)NULL);
}

void TerminateModule_stormcheck(void) {
    mxDestroyArray(_mxarray4_);
    mxDestroyArray(_mxarray3_);
    mxDestroyArray(_mxarray2_);
    mxDestroyArray(_mxarray1_);
    mxDestroyArray(_mxarray0_);
}

static mxArray * Mstormcheck(int nargout_, mxArray * x, mxArray * gap);

_mexLocalFunctionTable _local_function_table_stormcheck
  = { 0, (mexFunctionTableEntry *)NULL };

/*
 * The function "mlfStormcheck" contains the normal interface for the
 * "stormcheck" M-function from file "u:\final_recarga6\recarga\stormcheck.m"
 * (lines 1-78). This function processes any input arguments and passes them to
 * the implementation version of the function, appearing above.
 */
mxArray * mlfStormcheck(mxArray * x, mxArray * gap) {
    int nargout = 1;
    mxArray * y = NULL;
    mlfEnterNewContext(0, 2, x, gap);
    y = Mstormcheck(nargout, x, gap);
    mlfRestorePreviousContext(0, 2, x, gap);
    return mlfReturnValue(y);
}

/*
 * The function "mlxStormcheck" contains the feval interface for the
 * "stormcheck" M-function from file "u:\final_recarga6\recarga\stormcheck.m"
 * (lines 1-78). The feval function calls the implementation version of
 * stormcheck through this function. This function processes any input
 * arguments and passes them to the implementation version of the function,
 * appearing above.
 */
void mlxStormcheck(int nlhs, mxArray * plhs[], int nrhs, mxArray * prhs[]) {
    mxArray * mprhs[2];
    mxArray * mplhs[1];
    int i;
    if (nlhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: stormcheck Line: 1 Column:"
            " 1 The function \"stormcheck\" was called with m"
            "ore than the declared number of outputs (1)."),
          NULL);
    }
    if (nrhs > 2) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: stormcheck Line: 1 Column"
            ": 1 The function \"stormcheck\" was called with"
            " more than the declared number of inputs (2)."),
          NULL);
    }
    for (i = 0; i < 1; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 2 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 2; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 2, mprhs[0], mprhs[1]);
    mplhs[0] = Mstormcheck(nlhs, mprhs[0], mprhs[1]);
    mlfRestorePreviousContext(0, 2, mprhs[0], mprhs[1]);
    plhs[0] = mplhs[0];
}

/*
 * The function "Mstormcheck" is the implementation version of the "stormcheck"
 * M-function from file "u:\final_recarga6\recarga\stormcheck.m" (lines 1-78).
 * It contains the actual compiled code for that M-function. It is a static
 * function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function y = stormcheck (x, gap)
 */
static mxArray * Mstormcheck(int nargout_, mxArray * x, mxArray * gap) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_stormcheck);
    mxArray * y = NULL;
    mxArray * events = NULL;
    mxArray * infocheck = NULL;
    mxArray * j = NULL;
    mxArray * check = NULL;
    mxArray * i = NULL;
    mxArray * startcheck = NULL;
    mxArray * storms = NULL;
    mxArray * datapts = NULL;
    mclCopyArray(&x);
    mclCopyArray(&gap);
    /*
     * %
     * % Accepts a 2-column array x with columns for time and precipitation
     * % and a parameter 'gap' indicating how many time steps without precipitation
     * % represents a transition from one storm event to another.
     * %
     * % Returns a 4-column array y, repeating the columns in x and adding
     * % a third column that indicates whether the time step is part of a storm event
     * % as defined when the function eventinfo.m is called, as well as a fourth column indicating
     * % how many time steps the storm lasts for.
     * %
     * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     * % INITIALIZATION OF VARIABLES                             %
     * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     * datapts = size (x,1); % Check to see how many data points are in the series
     */
    mlfAssign(
      &datapts, mlfSize(mclValueVarargout(), mclVa(x, "x"), _mxarray0_));
    /*
     * storms = ones(datapts,3); % Set up a 3-column array for finding storm events
     */
    mlfAssign(&storms, mlfOnes(mclVv(datapts, "datapts"), _mxarray1_, NULL));
    /*
     * startcheck = 0; % Initialize variable to deal with initial time steps
     */
    mlfAssign(&startcheck, _mxarray2_);
    /*
     * %
     * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     * % COPY ARGUMENT ARRAY INTO FIRST TWO COLUMNS OF NEW ARRAY %
     * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     * % for i = 1:datapts
     * %     storms(i,1) = x(i,1);
     * %     storms(i,2) = x(i,2);
     * % end;
     * storms(:,1)=x(:,1); storms(:,2)=x(:,2);
     */
    mclArrayAssign2(
      &storms,
      mclArrayRef2(mclVa(x, "x"), mlfCreateColonIndex(), _mxarray0_),
      mlfCreateColonIndex(),
      _mxarray0_);
    mclArrayAssign2(
      &storms,
      mclArrayRef2(mclVa(x, "x"), mlfCreateColonIndex(), _mxarray3_),
      mlfCreateColonIndex(),
      _mxarray3_);
    /*
     * %
     * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     * % GO FORWARD THROUGH ARGUMENT ARRAY AND LOOK FOR GAPS    %
     * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     * for i = 1:(datapts-(gap-1))     % beware of too short a file, index may go to zero!!! (gap>1 also!)
     */
    {
        int v_ = mclForIntStart(1);
        int e_
          = mclForIntEnd(
              mclMinus(
                mclVv(datapts, "datapts"),
                mclMinus(mclVa(gap, "gap"), _mxarray0_)));
        if (v_ > e_) {
            mlfAssign(&i, _mxarray4_);
        } else {
            /*
             * if startcheck == 0 & x(i,2) == 0
             * storms (i,3) = 0; % no event indicated
             * else
             * ; % do nothing to alter ones array
             * end;
             * check = 0; % Initialize variable looking for non-zero values
             * for j = 0:(gap-1)   % look for non-zero rain in gap
             * if x(i+j,2)==0
             * ;   % no rain in time step
             * else
             * check = 1; % Indicate that non-zero values are in gap
             * startcheck = 1; % End initial series of zeros indicating no event (3rd column in storms)
             * end;
             * end;
             * if check == 0 % If all values in gap were zero, this is true
             * for j = 0:(gap-1)   
             * storms(i+j,3)=0; % Loop assigns zero values indicating no event 
             * end;
             * i = i + gap; % Gap found, so check moves to datapoint beyond gap
             * else
             * ; % If a gap was not found, nothing is done to alter the ones array
             * end;
             * end;
             */
            for (; ; ) {
                mlfAssign(&i, mlfScalar(v_));
                {
                    mxArray * a_
                      = mclInitialize(
                          mclEq(mclVv(startcheck, "startcheck"), _mxarray2_));
                    if (mlfTobool(a_)
                        && mlfTobool(
                             mclAnd(
                               a_,
                               mclEq(
                                 mclArrayRef2(
                                   mclVa(x, "x"), mclVv(i, "i"), _mxarray3_),
                                 _mxarray2_)))) {
                        mxDestroyArray(a_);
                        mclArrayAssign2(
                          &storms, _mxarray2_, mclVv(i, "i"), _mxarray1_);
                    } else {
                        mxDestroyArray(a_);
                    }
                }
                mlfAssign(&check, _mxarray2_);
                {
                    int v_0 = mclForIntStart(0);
                    int e_0
                      = mclForIntEnd(mclMinus(mclVa(gap, "gap"), _mxarray0_));
                    if (v_0 > e_0) {
                        mlfAssign(&j, _mxarray4_);
                    } else {
                        for (; ; ) {
                            if (mclEqBool(
                                  mclArrayRef2(
                                    mclVa(x, "x"),
                                    mclPlus(mclVv(i, "i"), mlfScalar(v_0)),
                                    _mxarray3_),
                                  _mxarray2_)) {
                            } else {
                                mlfAssign(&check, _mxarray0_);
                                mlfAssign(&startcheck, _mxarray0_);
                            }
                            if (v_0 == e_0) {
                                break;
                            }
                            ++v_0;
                        }
                        mlfAssign(&j, mlfScalar(v_0));
                    }
                }
                if (mclEqBool(mclVv(check, "check"), _mxarray2_)) {
                    int v_1 = mclForIntStart(0);
                    int e_1
                      = mclForIntEnd(mclMinus(mclVa(gap, "gap"), _mxarray0_));
                    if (v_1 > e_1) {
                        mlfAssign(&j, _mxarray4_);
                    } else {
                        for (; ; ) {
                            mclArrayAssign2(
                              &storms,
                              _mxarray2_,
                              mclPlus(mclVv(i, "i"), mlfScalar(v_1)),
                              _mxarray1_);
                            if (v_1 == e_1) {
                                break;
                            }
                            ++v_1;
                        }
                        mlfAssign(&j, mlfScalar(v_1));
                    }
                    mlfAssign(&i, mclPlus(mclVv(i, "i"), mclVa(gap, "gap")));
                } else {
                }
                if (v_ == e_) {
                    break;
                }
                ++v_;
            }
        }
    }
    /*
     * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     * % GO BACKWARDS THROUGH ARRAY AND FILL IN FINAL VALUES    %
     * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     * check = 0; 
     */
    mlfAssign(&check, _mxarray2_);
    /*
     * for i = 0:(gap-2)
     */
    {
        int v_ = mclForIntStart(0);
        int e_ = mclForIntEnd(mclMinus(mclVa(gap, "gap"), _mxarray3_));
        if (v_ > e_) {
            mlfAssign(&i, _mxarray4_);
        } else {
            /*
             * j = datapts - i;
             * if (check == 0) & (x(j,2) == 0)
             * storms(j,3) = 0;
             * else
             * check = 1;
             * storms(j,3)=1;
             * end;
             * end;
             */
            for (; ; ) {
                mlfAssign(
                  &j, mclMinus(mclVv(datapts, "datapts"), mlfScalar(v_)));
                {
                    mxArray * a_
                      = mclInitialize(
                          mclEq(mclVv(check, "check"), _mxarray2_));
                    if (mlfTobool(a_)
                        && mlfTobool(
                             mclAnd(
                               a_,
                               mclEq(
                                 mclArrayRef2(
                                   mclVa(x, "x"), mclVv(j, "j"), _mxarray3_),
                                 _mxarray2_)))) {
                        mxDestroyArray(a_);
                        mclArrayAssign2(
                          &storms, _mxarray2_, mclVv(j, "j"), _mxarray1_);
                    } else {
                        mxDestroyArray(a_);
                        mlfAssign(&check, _mxarray0_);
                        mclArrayAssign2(
                          &storms, _mxarray0_, mclVv(j, "j"), _mxarray1_);
                    }
                }
                if (v_ == e_) {
                    break;
                }
                ++v_;
            }
            mlfAssign(&i, mlfScalar(v_));
        }
    }
    /*
     * infocheck = eventinfo(storms);
     */
    mlfAssign(&infocheck, mlfEventinfo(mclVv(storms, "storms")));
    /*
     * events = size(infocheck,1);
     */
    mlfAssign(
      &events,
      mlfSize(mclValueVarargout(), mclVv(infocheck, "infocheck"), _mxarray0_));
    /*
     * for i = 1:events
     */
    {
        int v_ = mclForIntStart(1);
        int e_ = mclForIntEnd(mclVv(events, "events"));
        if (v_ > e_) {
            mlfAssign(&i, _mxarray4_);
        } else {
            /*
             * for j=1:datapts
             * if infocheck(i,2)==j
             * storms(j,4)=infocheck(i,4);
             * end;
             * end;
             * end;
             */
            for (; ; ) {
                int v_2 = mclForIntStart(1);
                int e_2 = mclForIntEnd(mclVv(datapts, "datapts"));
                if (v_2 > e_2) {
                    mlfAssign(&j, _mxarray4_);
                } else {
                    for (; ; ) {
                        if (mclEqBool(
                              mclIntArrayRef2(
                                mclVv(infocheck, "infocheck"), v_, 2),
                              mlfScalar(v_2))) {
                            mclIntArrayAssign2(
                              &storms,
                              mclIntArrayRef2(
                                mclVv(infocheck, "infocheck"), v_, 4),
                              v_2,
                              4);
                        }
                        if (v_2 == e_2) {
                            break;
                        }
                        ++v_2;
                    }
                    mlfAssign(&j, mlfScalar(v_2));
                }
                if (v_ == e_) {
                    break;
                }
                ++v_;
            }
            mlfAssign(&i, mlfScalar(v_));
        }
    }
    /*
     * y=storms;
     */
    mlfAssign(&y, mclVv(storms, "storms"));
    mclValidateOutput(y, 1, nargout_, "y", "stormcheck");
    mxDestroyArray(datapts);
    mxDestroyArray(storms);
    mxDestroyArray(startcheck);
    mxDestroyArray(i);
    mxDestroyArray(check);
    mxDestroyArray(j);
    mxDestroyArray(infocheck);
    mxDestroyArray(events);
    mxDestroyArray(gap);
    mxDestroyArray(x);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return y;
}
