function y = storageout (timerain, Sd, evaprate, data4)
%
% Accepts a 2-column array, timerain, with columns for time and ppt
% Sd, the storage depth, and evaprate, the rate of evaporation.
% It goes through the precipitation table and takes off the storage
% depth for the entire array.
% The evaporation rate must be in compatible units with Sd and timerain
% (e.g., if Sd is in inches and the time step in the timerain table is 
% hours, then evaprate must be in inches per hour).
%
avail = Sd; % initializes the available storage depth
datapts = size(timerain,1); % Determines the number of data points
for i = 1:datapts
    newtimerain(i,1) = timerain(i,1); % time
    if avail <= 0
        newtimerain(i,2) = timerain(i,2);   % no effect in effective rain if no avail storage
    elseif avail >= timerain(i,2) % storage bigger than rain
        newtimerain(i,2) = 0;   % zero effective rain (all stored)
        avail = avail - timerain(i,2);  % correct for rain using avail storage
        if avail < 0
            avail = 0;
        end
    elseif avail < timerain(i,2)  % storage less than rain
        newtimerain(i,2) = timerain(i,2) - avail;
        if newtimerain(i,2)<0
            newtimerain = 0;
        end
        avail = 0;
    end
    if data4(i,3)==0 
        avail = avail + evaprate; % evap increases avail storage only in dry periods
    end  
    if avail > Sd
        avail = Sd;
    end
    Pcompl=100*i/datapts; % {DBA}
    %set(handles.Progress,'String',num2str(Pcompl)); %{DBA}
end
y = newtimerain;