%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RAIN GARDEN SENSITIVITY PARAMETERS:
    R=10;		% ratio of impervious to pervious area
Aimp=Arg*R; % impervious area connected to rain garden [m2]
    dmin=15;		% min depth for weir [cm]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SOIL SENSITIVITY PARAMETERS:
KSAT = [10.16 15 1];	% sat. hydraulic conductivity [cm/h]
    thick = [30 10 10];		% thickness of RZ, TZ, CZ layers [cm]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% TEMPORAL PARAMETERS:
stime=time/60;				% total time of simulation [h]
dt=dt/60;					% TIME STEP [h]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SPATIAL PARAMETERS:
totdepth=thick(1,1)+thick(1,2)+thick(1,3);	% spatial extent [cm]
m=totdepth./dx+1;	            % total number of spatial nodes
x=0:dx:totdepth; x=x';	    	% cm, x downwards, i nodes downwards
z=flipdim(x,1);					% z upwards
rf=thick(1,1)./dx+1;ti=rf+1;	% boundary root zone - transm zone
tf=(thick(1,1)+thick(1,2))/dx; ci=tf+1;	% TZ - confining layer
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INITIAL CONDITIONS:
hin=-100;					% [cm]
for i=1:3
    theta_init(i)=THETAH(hin,AA(i),N(i),NSAT(i),NRES(i),Ss(i),h0(i));
end
hinit=ones(m,1); hinit=hin*hinit; hs=hin;   % initial value of pressure heads [cm]
Sinit=zeros(m,1); Sold=Sinit;               % initial value of ET
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  RAIN DATA RETRIEVAL:                                                    
nprecip=dlmread('rainsea95h.txt','\t',[1 0 ceil(stime)+1 1]);
nprecip(:,2)=nprecip(:,2)./10;      %convert from [mm h-1] to [cm h-1]
qs=nprecip(1,2);    %first value for surface flux [cm h-1]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Set bottom boundary condition as pressure head (TYPE 1) [cm]:
    %bbc=1; hb=hin; hinit(m)=hb;			% head - Dirichlet
    bbc=3;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% OUTPUT FILE:
    outfile='rg95seawar10s10p15k10mm.txt';
