function y = eventinfo(x)
% Takes a three-column array produced by stormcheck.m and returns
% a four-column array, with columns indicating the storm number
% (sequentially listing storms 1,2,3...), the time step at which the
% event began, the value of rainfall at the first time step of the
% event, and the length of the storm event (number of time steps).
storms = x(:,3);    % column indicating if part of storm (=1) or not (=0)
datapts = size(storms,1);
events = 0;
for i = 1:(datapts-1)
    j = i + 1;
    if (storms(i)==0 & storms(j)==1) | (i==1 & storms(i)==1) % start of a storm
        lengthcheck = 0;        % initialize value for total length of storm event
        events = events + 1;    % new storm event
        info(events,1) = events;    % first column: event #
        info(events,2) = j;         % second: storm start time step
        info(events,3) = x(j,2);    % third: rain magnitude at start
        %
        % check for storm at start of data file (special case):
        if i==1 & storms(i)==1  
            info(events,2)=i; info(events,3)=x(i,2);
        end
        %
        % loop to determine length of storm event:
        check = 0;
        while check == 0    
            lengthcheck = lengthcheck + 1;
            j = j + 1;
            if j > datapts | storms(j) == 0 % if reaches end of file or a no-storm period
                check = 1;                
            end
        end
        info(events,4) = lengthcheck;   % length of the storm event
        %else
        %info(events,4) = 0;
    end
end
y = info;

