/*
 * MATLAB Compiler: 3.0
 * Date: Mon Sep 20 09:40:17 2004
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-B" "sgl" "-m" "-W"
 * "main" "-L" "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "-W" "mainhg"
 * "libmwsglm.mlib" "recarga_multiple" 
 */
#include "eventinfo.h"
#include "libmatlbm.h"
static mxArray * _mxarray0_;
static mxArray * _mxarray1_;
static mxArray * _mxarray2_;
static mxArray * _mxarray3_;
static mxArray * _mxarray4_;
static mxArray * _mxarray5_;

void InitializeModule_eventinfo(void) {
    _mxarray0_ = mclInitializeDouble(3.0);
    _mxarray1_ = mclInitializeDouble(1.0);
    _mxarray2_ = mclInitializeDouble(0.0);
    _mxarray3_ = mclInitializeDoubleVector(0, 0, (double *)NULL);
    _mxarray4_ = mclInitializeDouble(2.0);
    _mxarray5_ = mclInitializeDouble(4.0);
}

void TerminateModule_eventinfo(void) {
    mxDestroyArray(_mxarray5_);
    mxDestroyArray(_mxarray4_);
    mxDestroyArray(_mxarray3_);
    mxDestroyArray(_mxarray2_);
    mxDestroyArray(_mxarray1_);
    mxDestroyArray(_mxarray0_);
}

static mxArray * Meventinfo(int nargout_, mxArray * x);

_mexLocalFunctionTable _local_function_table_eventinfo
  = { 0, (mexFunctionTableEntry *)NULL };

/*
 * The function "mlfEventinfo" contains the normal interface for the
 * "eventinfo" M-function from file "u:\final_recarga6\recarga\eventinfo.m"
 * (lines 1-40). This function processes any input arguments and passes them to
 * the implementation version of the function, appearing above.
 */
mxArray * mlfEventinfo(mxArray * x) {
    int nargout = 1;
    mxArray * y = NULL;
    mlfEnterNewContext(0, 1, x);
    y = Meventinfo(nargout, x);
    mlfRestorePreviousContext(0, 1, x);
    return mlfReturnValue(y);
}

/*
 * The function "mlxEventinfo" contains the feval interface for the "eventinfo"
 * M-function from file "u:\final_recarga6\recarga\eventinfo.m" (lines 1-40).
 * The feval function calls the implementation version of eventinfo through
 * this function. This function processes any input arguments and passes them
 * to the implementation version of the function, appearing above.
 */
void mlxEventinfo(int nlhs, mxArray * plhs[], int nrhs, mxArray * prhs[]) {
    mxArray * mprhs[1];
    mxArray * mplhs[1];
    int i;
    if (nlhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: eventinfo Line: 1 Column:"
            " 1 The function \"eventinfo\" was called with m"
            "ore than the declared number of outputs (1)."),
          NULL);
    }
    if (nrhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: eventinfo Line: 1 Column:"
            " 1 The function \"eventinfo\" was called with m"
            "ore than the declared number of inputs (1)."),
          NULL);
    }
    for (i = 0; i < 1; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 1 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 1; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 1, mprhs[0]);
    mplhs[0] = Meventinfo(nlhs, mprhs[0]);
    mlfRestorePreviousContext(0, 1, mprhs[0]);
    plhs[0] = mplhs[0];
}

/*
 * The function "Meventinfo" is the implementation version of the "eventinfo"
 * M-function from file "u:\final_recarga6\recarga\eventinfo.m" (lines 1-40).
 * It contains the actual compiled code for that M-function. It is a static
 * function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function y = eventinfo(x)
 */
static mxArray * Meventinfo(int nargout_, mxArray * x) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_eventinfo);
    mxArray * y = NULL;
    mxArray * check = NULL;
    mxArray * info = NULL;
    mxArray * lengthcheck = NULL;
    mxArray * j = NULL;
    mxArray * i = NULL;
    mxArray * events = NULL;
    mxArray * datapts = NULL;
    mxArray * storms = NULL;
    mclCopyArray(&x);
    /*
     * % Takes a three-column array produced by stormcheck.m and returns
     * % a four-column array, with columns indicating the storm number
     * % (sequentially listing storms 1,2,3...), the time step at which the
     * % event began, the value of rainfall at the first time step of the
     * % event, and the length of the storm event (number of time steps).
     * storms = x(:,3);    % column indicating if part of storm (=1) or not (=0)
     */
    mlfAssign(
      &storms, mclArrayRef2(mclVa(x, "x"), mlfCreateColonIndex(), _mxarray0_));
    /*
     * datapts = size(storms,1);
     */
    mlfAssign(
      &datapts,
      mlfSize(mclValueVarargout(), mclVv(storms, "storms"), _mxarray1_));
    /*
     * events = 0;
     */
    mlfAssign(&events, _mxarray2_);
    /*
     * for i = 1:(datapts-1)
     */
    {
        int v_ = mclForIntStart(1);
        int e_ = mclForIntEnd(mclMinus(mclVv(datapts, "datapts"), _mxarray1_));
        if (v_ > e_) {
            mlfAssign(&i, _mxarray3_);
        } else {
            /*
             * j = i + 1;
             * if (storms(i)==0 & storms(j)==1) | (i==1 & storms(i)==1) % start of a storm
             * lengthcheck = 0;        % initialize value for total length of storm event
             * events = events + 1;    % new storm event
             * info(events,1) = events;    % first column: event #
             * info(events,2) = j;         % second: storm start time step
             * info(events,3) = x(j,2);    % third: rain magnitude at start
             * %
             * % check for storm at start of data file (special case):
             * if i==1 & storms(i)==1  
             * info(events,2)=i; info(events,3)=x(i,2);
             * end
             * %
             * % loop to determine length of storm event:
             * check = 0;
             * while check == 0    
             * lengthcheck = lengthcheck + 1;
             * j = j + 1;
             * if j > datapts | storms(j) == 0 % if reaches end of file or a no-storm period
             * check = 1;                
             * end
             * end
             * info(events,4) = lengthcheck;   % length of the storm event
             * %else
             * %info(events,4) = 0;
             * end
             * end
             */
            for (; ; ) {
                mlfAssign(&j, mlfScalar(v_ + 1));
                {
                    mxArray * a_
                      = mclInitialize(
                          mclEq(
                            mclIntArrayRef1(mclVv(storms, "storms"), v_),
                            _mxarray2_));
                    if (mlfTobool(a_)) {
                        mlfAssign(
                          &a_,
                          mclAnd(
                            a_,
                            mclEq(
                              mclArrayRef1(
                                mclVv(storms, "storms"), mclVv(j, "j")),
                              _mxarray1_)));
                    } else {
                        mlfAssign(&a_, mlfScalar(0));
                    }
                    if (mlfTobool(a_)) {
                    } else {
                        mxArray * b_ = mclInitialize(mclBoolToArray(v_ == 1));
                        if (mlfTobool(b_)) {
                            mlfAssign(
                              &b_,
                              mclAnd(
                                b_,
                                mclEq(
                                  mclIntArrayRef1(mclVv(storms, "storms"), v_),
                                  _mxarray1_)));
                        } else {
                            mlfAssign(&b_, mlfScalar(0));
                        }
                        {
                            mxLogical c_0 = mlfTobool(mclOr(a_, b_));
                            mxDestroyArray(b_);
                            if (c_0) {
                            } else {
                                mxDestroyArray(a_);
                                goto done_;
                            }
                        }
                    }
                    mxDestroyArray(a_);
                    mlfAssign(&lengthcheck, _mxarray2_);
                    mlfAssign(
                      &events, mclPlus(mclVv(events, "events"), _mxarray1_));
                    mclArrayAssign2(
                      &info,
                      mclVv(events, "events"),
                      mclVv(events, "events"),
                      _mxarray1_);
                    mclArrayAssign2(
                      &info,
                      mclVv(j, "j"),
                      mclVv(events, "events"),
                      _mxarray4_);
                    mclArrayAssign2(
                      &info,
                      mclArrayRef2(mclVa(x, "x"), mclVv(j, "j"), _mxarray4_),
                      mclVv(events, "events"),
                      _mxarray0_);
                    {
                        mxArray * a_0 = mclInitialize(mclBoolToArray(v_ == 1));
                        if (mlfTobool(a_0)
                            && mlfTobool(
                                 mclAnd(
                                   a_0,
                                   mclEq(
                                     mclIntArrayRef1(
                                       mclVv(storms, "storms"), v_),
                                     _mxarray1_)))) {
                            mxDestroyArray(a_0);
                            mclArrayAssign2(
                              &info,
                              mlfScalar(v_),
                              mclVv(events, "events"),
                              _mxarray4_);
                            mclArrayAssign2(
                              &info,
                              mclIntArrayRef2(mclVa(x, "x"), v_, 2),
                              mclVv(events, "events"),
                              _mxarray0_);
                        } else {
                            mxDestroyArray(a_0);
                        }
                    }
                    mlfAssign(&check, _mxarray2_);
                    while (mclEqBool(mclVv(check, "check"), _mxarray2_)) {
                        mlfAssign(
                          &lengthcheck,
                          mclPlus(
                            mclVv(lengthcheck, "lengthcheck"), _mxarray1_));
                        mlfAssign(&j, mclPlus(mclVv(j, "j"), _mxarray1_));
                        {
                            mxArray * a_1
                              = mclInitialize(
                                  mclGt(
                                    mclVv(j, "j"), mclVv(datapts, "datapts")));
                            if (mlfTobool(a_1)
                                || mlfTobool(
                                     mclOr(
                                       a_1,
                                       mclEq(
                                         mclArrayRef1(
                                           mclVv(storms, "storms"),
                                           mclVv(j, "j")),
                                         _mxarray2_)))) {
                                mxDestroyArray(a_1);
                                mlfAssign(&check, _mxarray1_);
                            } else {
                                mxDestroyArray(a_1);
                            }
                        }
                    }
                    mclArrayAssign2(
                      &info,
                      mclVv(lengthcheck, "lengthcheck"),
                      mclVv(events, "events"),
                      _mxarray5_);
                    done_:;
                }
                if (v_ == e_) {
                    break;
                }
                ++v_;
            }
            mlfAssign(&i, mlfScalar(v_));
        }
    }
    /*
     * y = info;
     */
    mlfAssign(&y, mclVv(info, "info"));
    mclValidateOutput(y, 1, nargout_, "y", "eventinfo");
    mxDestroyArray(storms);
    mxDestroyArray(datapts);
    mxDestroyArray(events);
    mxDestroyArray(i);
    mxDestroyArray(j);
    mxDestroyArray(lengthcheck);
    mxDestroyArray(info);
    mxDestroyArray(check);
    mxDestroyArray(x);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return y;
    /*
     * 
     */
}
