/*
 * MATLAB Compiler: 3.0
 * Date: Mon Sep 20 09:40:02 2004
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-B" "sgl" "-m" "-W"
 * "main" "-L" "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "-W" "mainhg"
 * "libmwsglm.mlib" "recarga_multiple" 
 */
#include "dlmread.h"
#include "iofun_private_guessdelim.h"
#include "libmatlbm.h"
#include "libmmfile.h"
#include "str2rng.h"
#include "textread.h"

static mxChar _array1_[27] = { 'N', 'o', 't', ' ', 'e', 'n', 'o', 'u', 'g',
                               'h', ' ', 'i', 'n', 'p', 'u', 't', ' ', 'a',
                               'r', 'g', 'u', 'm', 'e', 'n', 't', 's', '.' };
static mxArray * _mxarray0_;

static mxChar _array3_[26] = { 'F', 'i', 'l', 'e', 'n', 'a', 'm', 'e', ' ',
                               'm', 'u', 's', 't', ' ', 'b', 'e', ' ', 'a',
                               ' ', 's', 't', 'r', 'i', 'n', 'g', '.' };
static mxArray * _mxarray2_;
static mxArray * _mxarray4_;

static mxChar _array6_[15] = { 'F', 'i', 'l', 'e', ' ', 'n', 'o', 't',
                               ' ', 'f', 'o', 'u', 'n', 'd', '.' };
static mxArray * _mxarray5_;
static mxArray * _mxarray7_;

static mxChar _array9_[37] = { 'D', 'E', 'L', 'I', 'M', 'I', 'T', 'E', 'R', ' ',
                               'm', 'u', 's', 't', ' ', 'b', 'e', ' ', 'a', ' ',
                               's', 'i', 'n', 'g', 'l', 'e', ' ', 'c', 'h', 'a',
                               'r', 'a', 'c', 't', 'e', 'r', '.' };
static mxArray * _mxarray8_;
static mxArray * _mxarray10_;
static mxArray * _mxarray11_;
static mxArray * _mxarray12_;

static mxChar _array14_[44] = { 'O', 'b', 's', 'o', 'l', 'e', 't', 'e', ' ',
                                's', 'y', 'n', 't', 'a', 'x', '.', ' ', 'C',
                                ' ', 'm', 'u', 's', 't', ' ', 'b', 'e', ' ',
                                's', 'p', 'e', 'c', 'i', 'f', 'i', 'e', 'd',
                                ' ', 'w', 'i', 't', 'h', ' ', 'R', '.' };
static mxArray * _mxarray13_;
static mxArray * _mxarray15_;

static mxChar _array17_[76] = { 'R', ' ', 'a', 'n', 'd', ' ', 'C', ' ', 's',
                                'h', 'o', 'u', 'l', 'd', ' ', 'm', 'a', 't',
                                'c', 'h', ' ', 'R', 'A', 'N', 'G', 'E', '(',
                                '1', ':', '2', ')', '.', ' ', ' ', 'U', 's',
                                'e', ' ', 'D', 'L', 'M', 'R', 'E', 'A', 'D',
                                '(', 'F', 'I', 'L', 'E', ',', 'D', 'E', 'L',
                                'I', 'M', 'I', 'T', 'E', 'R', ',', 'R', 'A',
                                'N', 'G', 'E', ')', ' ', 'i', 'n', 's', 't',
                                'e', 'a', 'd', '.' };
static mxArray * _mxarray16_;

static mxChar _array19_[1] = { ' ' };
static mxArray * _mxarray18_;
static mxArray * _mxarray20_;

static mxChar _array22_[11] = { 'h', 'e', 'a', 'd', 'e', 'r',
                                'l', 'i', 'n', 'e', 's' };
static mxArray * _mxarray21_;

static mxChar _array24_[13] = { 'h', 'e', 'a', 'd', 'e', 'r', 'c',
                                'o', 'l', 'u', 'm', 'n', 's' };
static mxArray * _mxarray23_;

static mxChar _array26_[7] = { ' ', 0x005c, 'b', 0x005c, 'r', 0x005c, 't' };
static mxArray * _mxarray25_;

static mxChar _array28_[9] = { 'd', 'e', 'l', 'i', 'm', 'i', 't', 'e', 'r' };
static mxArray * _mxarray27_;

static mxChar _array30_[10] = { 'w', 'h', 'i', 't', 'e',
                                's', 'p', 'a', 'c', 'e' };
static mxArray * _mxarray29_;

static mxChar _array32_[22] = { 'I', 'n', 't', 'e', 'r', 'n', 'a', 'l',
                                ' ', 's', 'i', 'z', 'e', ' ', 'm', 'i',
                                's', 'm', 'a', 't', 'c', 'h' };
static mxArray * _mxarray31_;

void InitializeModule_dlmread(void) {
    _mxarray0_ = mclInitializeString(27, _array1_);
    _mxarray2_ = mclInitializeString(26, _array3_);
    _mxarray4_ = mclInitializeDouble(2.0);
    _mxarray5_ = mclInitializeString(15, _array6_);
    _mxarray7_ = mclInitializeDouble(4096.0);
    _mxarray8_ = mclInitializeString(37, _array9_);
    _mxarray10_ = mclInitializeDouble(0.0);
    _mxarray11_ = mclInitializeDouble(-1.0);
    _mxarray12_ = mclInitializeDoubleVector(0, 0, (double *)NULL);
    _mxarray13_ = mclInitializeString(44, _array14_);
    _mxarray15_ = mclInitializeDouble(1.0);
    _mxarray16_ = mclInitializeString(76, _array17_);
    _mxarray18_ = mclInitializeString(1, _array19_);
    _mxarray20_ = mclInitializeCharVector(0, 0, (mxChar *)NULL);
    _mxarray21_ = mclInitializeString(11, _array22_);
    _mxarray23_ = mclInitializeString(13, _array24_);
    _mxarray25_ = mclInitializeString(7, _array26_);
    _mxarray27_ = mclInitializeString(9, _array28_);
    _mxarray29_ = mclInitializeString(10, _array30_);
    _mxarray31_ = mclInitializeString(22, _array32_);
}

void TerminateModule_dlmread(void) {
    mxDestroyArray(_mxarray31_);
    mxDestroyArray(_mxarray29_);
    mxDestroyArray(_mxarray27_);
    mxDestroyArray(_mxarray25_);
    mxDestroyArray(_mxarray23_);
    mxDestroyArray(_mxarray21_);
    mxDestroyArray(_mxarray20_);
    mxDestroyArray(_mxarray18_);
    mxDestroyArray(_mxarray16_);
    mxDestroyArray(_mxarray15_);
    mxDestroyArray(_mxarray13_);
    mxDestroyArray(_mxarray12_);
    mxDestroyArray(_mxarray11_);
    mxDestroyArray(_mxarray10_);
    mxDestroyArray(_mxarray8_);
    mxDestroyArray(_mxarray7_);
    mxDestroyArray(_mxarray5_);
    mxDestroyArray(_mxarray4_);
    mxDestroyArray(_mxarray2_);
    mxDestroyArray(_mxarray0_);
}

static mxArray * Mdlmread(int nargout_,
                          mxArray * filename,
                          mxArray * delimiter,
                          mxArray * r,
                          mxArray * c,
                          mxArray * range);

_mexLocalFunctionTable _local_function_table_dlmread
  = { 0, (mexFunctionTableEntry *)NULL };

/*
 * The function "mlfDlmread" contains the normal interface for the "dlmread"
 * M-function from file
 * "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\dlmread.m" (lines 1-150). This
 * function processes any input arguments and passes them to the implementation
 * version of the function, appearing above.
 */
mxArray * mlfDlmread(mxArray * filename,
                     mxArray * delimiter,
                     mxArray * r,
                     mxArray * c,
                     mxArray * range) {
    int nargout = 1;
    mxArray * result = NULL;
    mlfEnterNewContext(0, 5, filename, delimiter, r, c, range);
    result = Mdlmread(nargout, filename, delimiter, r, c, range);
    mlfRestorePreviousContext(0, 5, filename, delimiter, r, c, range);
    return mlfReturnValue(result);
}

/*
 * The function "mlxDlmread" contains the feval interface for the "dlmread"
 * M-function from file
 * "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\dlmread.m" (lines 1-150). The
 * feval function calls the implementation version of dlmread through this
 * function. This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
void mlxDlmread(int nlhs, mxArray * plhs[], int nrhs, mxArray * prhs[]) {
    mxArray * mprhs[5];
    mxArray * mplhs[1];
    int i;
    if (nlhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: dlmread Line: 1 Column: "
            "1 The function \"dlmread\" was called with mor"
            "e than the declared number of outputs (1)."),
          NULL);
    }
    if (nrhs > 5) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: dlmread Line: 1 Column:"
            " 1 The function \"dlmread\" was called with m"
            "ore than the declared number of inputs (5)."),
          NULL);
    }
    for (i = 0; i < 1; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 5 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 5; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 5, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4]);
    mplhs[0] = Mdlmread(nlhs, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4]);
    mlfRestorePreviousContext(
      0, 5, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4]);
    plhs[0] = mplhs[0];
}

/*
 * The function "Mdlmread" is the implementation version of the "dlmread"
 * M-function from file
 * "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\dlmread.m" (lines 1-150). It
 * contains the actual compiled code for that M-function. It is a static
 * function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function result= dlmread(filename,delimiter,r,c,range)
 */
static mxArray * Mdlmread(int nargout_,
                          mxArray * filename,
                          mxArray * delimiter,
                          mxArray * r,
                          mxArray * c,
                          mxArray * range) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_dlmread);
    int nargin_ = mclNargin(5, filename, delimiter, r, c, range, NULL);
    mxArray * result = NULL;
    mxArray * new_result = NULL;
    mxArray * columnIndex = NULL;
    mxArray * rowIndex = NULL;
    mxArray * ncols = NULL;
    mxArray * whitespace = NULL;
    mxArray * cold = NULL;
    mxArray * rold = NULL;
    mxArray * nrows = NULL;
    mxArray * offset = NULL;
    mxArray * str = NULL;
    mxArray * fid = NULL;
    mxArray * ans = NULL;
    mclCopyArray(&filename);
    mclCopyArray(&delimiter);
    mclCopyArray(&r);
    mclCopyArray(&c);
    mclCopyArray(&range);
    /*
     * %DLMREAD Read ASCII delimited file.
     * %   RESULT= DLMREAD(FILENAME,DELIMITER) reads numeric data from the ASCII
     * %   delimited file FILENAME using the delimiter DELIMITER.  The result is
     * %   returned in RESULT.  Use '\t' to specify a tab.
     * %
     * %   RESULT= DLMREAD(FILENAME,DELIMITER,R,C) reads data from the
     * %   DELIMITER-delimited file FILENAME.  R and C specify the row R and column
     * %   C where the upper-left corner of the data lies in the file.  R and C are
     * %   zero-based so that R=0 and C=0 specifies the first value in the file.
     * %
     * %   RESULT= DLMREAD(FILENAME,DELIMITER,RANGE) reads the range specified
     * %   by RANGE = [R1 C1 R2 C2] where (R1,C1) is the upper-left corner of
     * %   the data to be read and (R2,C2) is the lower-right corner.  RANGE
     * %   can also be specified using spreadsheet notation as in RANGE = 'A1..B7'.
     * %
     * %   DLMREAD fills empty delimited fields with zero.  Data files where
     * %   the lines end with a non-space delimiter will produce a result with
     * %   an extra last column filled with zeros.
     * %
     * %   See also DLMWRITE, LOAD, FILEFORMATS
     * 
     * % Obsolete syntax:
     * %   RESULT= DLMREAD(FILENAME,DELIMITER,R,C,RANGE) reads only the range specified
     * %   by RANGE = [R1 C1 R2 C2] where (R1,C1) is the upper-left corner of
     * %   the data to be read and (R2,C2) is the lower-right corner.  RANGE
     * %   can also be specified using spreadsheet notation as in RANGE = 'A1..B7'.
     * %   A warning will be generated if R,C or both don't match the upper
     * %   left corner of the RANGE.
     * 
     * %   Copyright 1984-2002 The MathWorks, Inc.
     * %   $Revision: 5.40 $  $Date: 2002/06/05 20:06:46 $
     * 
     * % Validate input args
     * if nargin==0, error('Not enough input arguments.'); end
     */
    if (nargin_ == 0) {
        mlfError(_mxarray0_, NULL);
    }
    /*
     * 
     * % Get Filename
     * if ~isstr(filename), error('Filename must be a string.'); end
     */
    if (mclNotBool(mlfIsstr(mclVa(filename, "filename")))) {
        mlfError(_mxarray2_, NULL);
    }
    /*
     * 
     * % Make sure file exists
     * if ~isequal(exist(filename), 2), error('File not found.'), end
     */
    if (mclNotBool(
          mlfIsequal(
            mlfExist(mclVa(filename, "filename"), NULL), _mxarray4_, NULL))) {
        mlfError(_mxarray5_, NULL);
    }
    /*
     * 
     * % Get Delimiter
     * if nargin==1 % Guess default delimiter
     */
    if (nargin_ == 1) {
        /*
         * fid = fopen(filename);
         */
        mlfAssign(
          &fid, mlfFopen(NULL, NULL, mclVa(filename, "filename"), NULL, NULL));
        /*
         * str = char(fread(fid, 4096)');
         */
        mlfAssign(
          &str,
          mlfChar(
            mlfCtranspose(
              mlfFread(NULL, mclVv(fid, "fid"), _mxarray7_, NULL, NULL)),
            NULL));
        /*
         * fclose(fid);
         */
        mclAssignAns(&ans, mlfFclose(mclVv(fid, "fid")));
        /*
         * delimiter = guessdelim(str);
         */
        mlfAssign(&delimiter, mlfIofun_private_guessdelim(mclVv(str, "str")));
    /*
     * else
     */
    } else {
        /*
         * delimiter = sprintf(delimiter); % Interpret \t (if necessary)
         */
        mlfAssign(
          &delimiter, mlfSprintf(NULL, mclVa(delimiter, "delimiter"), NULL));
    /*
     * end
     */
    }
    /*
     * if length(delimiter) > 1,
     */
    if (mclLengthInt(mclVa(delimiter, "delimiter")) > 1) {
        /*
         * error('DELIMITER must be a single character.');
         */
        mlfError(_mxarray8_, NULL);
    /*
     * end
     */
    }
    /*
     * 
     * % Get row and column offsets
     * offset = 0;
     */
    mlfAssign(&offset, _mxarray10_);
    /*
     * if nargin<=2, % dlmread(file) or dlmread(file,dim)
     */
    if (nargin_ <= 2) {
        /*
         * r = 0;
         */
        mlfAssign(&r, _mxarray10_);
        /*
         * c = 0;
         */
        mlfAssign(&c, _mxarray10_);
        /*
         * nrows = -1; % Read all rows
         */
        mlfAssign(&nrows, _mxarray11_);
        /*
         * range = [];
         */
        mlfAssign(&range, _mxarray12_);
    /*
     * elseif nargin==3, % dlmread(file,delimiter,range)
     */
    } else if (nargin_ == 3) {
        /*
         * if length(r)==1, % Catch obsolete syntax dlmread(file,delimiter,r)
         */
        if (mclLengthInt(mclVa(r, "r")) == 1) {
            /*
             * warning('Obsolete syntax. C must be specified with R.');
             */
            mclAssignAns(&ans, mlfNWarning(0, NULL, _mxarray13_, NULL));
            /*
             * result= dlmread(filename,delimiter,r,0);
             */
            mlfAssign(
              &result,
              mlfDlmread(
                mclVa(filename, "filename"),
                mclVa(delimiter, "delimiter"),
                mclVa(r, "r"),
                _mxarray10_,
                NULL));
            /*
             * return
             */
            goto return_;
        /*
         * end
         */
        }
        /*
         * range = r;
         */
        mlfAssign(&range, mclVa(r, "r"));
        /*
         * if isstr(range)
         */
        if (mlfTobool(mlfIsstr(mclVa(range, "range")))) {
            /*
             * range = str2rng(range);
             */
            mlfAssign(&range, mlfStr2rng(mclVa(range, "range")));
        /*
         * end
         */
        }
        /*
         * r = range(1);
         */
        mlfAssign(&r, mclIntArrayRef1(mclVa(range, "range"), 1));
        /*
         * c = range(2);
         */
        mlfAssign(&c, mclIntArrayRef1(mclVa(range, "range"), 2));
        /*
         * nrows = range(3) - range(1) + 1;
         */
        mlfAssign(
          &nrows,
          mclPlus(
            mclMinus(
              mclIntArrayRef1(mclVa(range, "range"), 3),
              mclIntArrayRef1(mclVa(range, "range"), 1)),
            _mxarray15_));
    /*
     * elseif nargin==4, % dlmread(file,delimiter,r,c)
     */
    } else if (nargin_ == 4) {
        /*
         * nrows = -1; % Read all rows
         */
        mlfAssign(&nrows, _mxarray11_);
        /*
         * range = [];
         */
        mlfAssign(&range, _mxarray12_);
    /*
     * elseif nargin==5, % obsolete syntax dlmread(file,delimiter,r,c,range)
     */
    } else if (nargin_ == 5) {
        /*
         * if isstr(range)
         */
        if (mlfTobool(mlfIsstr(mclVa(range, "range")))) {
            /*
             * range = str2rng(range);
             */
            mlfAssign(&range, mlfStr2rng(mclVa(range, "range")));
        /*
         * end
         */
        }
        /*
         * rold = r; cold = c;
         */
        mlfAssign(&rold, mclVa(r, "r"));
        mlfAssign(&cold, mclVa(c, "c"));
        /*
         * if r > range(3) | c > range(4), result= []; return, end
         */
        {
            mxArray * a_
              = mclInitialize(
                  mclGt(
                    mclVa(r, "r"), mclIntArrayRef1(mclVa(range, "range"), 3)));
            if (mlfTobool(a_)
                || mlfTobool(
                     mclOr(
                       a_,
                       mclGt(
                         mclVa(c, "c"),
                         mclIntArrayRef1(mclVa(range, "range"), 4))))) {
                mxDestroyArray(a_);
                mlfAssign(&result, _mxarray12_);
                goto return_;
            } else {
                mxDestroyArray(a_);
            }
        }
        /*
         * if r ~= range(1) | c ~= range(2)
         */
        {
            mxArray * a_
              = mclInitialize(
                  mclNe(
                    mclVa(r, "r"), mclIntArrayRef1(mclVa(range, "range"), 1)));
            if (mlfTobool(a_)
                || mlfTobool(
                     mclOr(
                       a_,
                       mclNe(
                         mclVa(c, "c"),
                         mclIntArrayRef1(mclVa(range, "range"), 2))))) {
                mxDestroyArray(a_);
                /*
                 * warning(['R and C should match RANGE(1:2).  Use DLMREAD(FILE,DELIMITER,RANGE)' ...
                 */
                mclPrintAns(&ans, mlfNWarning(0, NULL, _mxarray16_, NULL));
                /*
                 * ' instead.'])
                 * offset = 1;
                 */
                mlfAssign(&offset, _mxarray15_);
            } else {
                mxDestroyArray(a_);
            }
        /*
         * end
         */
        }
        /*
         * % For compatibility
         * r = max(range(1),r);
         */
        mlfAssign(
          &r,
          mlfMax(
            NULL,
            mclIntArrayRef1(mclVa(range, "range"), 1),
            mclVa(r, "r"),
            NULL));
        /*
         * c = max(range(2),c);
         */
        mlfAssign(
          &c,
          mlfMax(
            NULL,
            mclIntArrayRef1(mclVa(range, "range"), 2),
            mclVa(c, "c"),
            NULL));
        /*
         * nrows = range(3) - r + 1;
         */
        mlfAssign(
          &nrows,
          mclPlus(
            mclMinus(mclIntArrayRef1(mclVa(range, "range"), 3), mclVa(r, "r")),
            _mxarray15_));
    /*
     * end
     */
    }
    /*
     * 
     * % Read the file using textread
     * if ~isempty(delimiter) & delimiter == ' '
     */
    {
        mxArray * a_
          = mclInitialize(mclNot(mlfIsempty(mclVa(delimiter, "delimiter"))));
        if (mlfTobool(a_)
            && mlfTobool(
                 mclAnd(
                   a_, mclEq(mclVa(delimiter, "delimiter"), _mxarray18_)))) {
            mxDestroyArray(a_);
            /*
             * result  = textread(filename,'',nrows,'headerlines',r,'headercolumns',c);
             */
            mlfAssign(
              &result,
              mlfNTextread(
                0,
                mclValueVarargout(),
                mclVa(filename, "filename"),
                _mxarray20_,
                mclVv(nrows, "nrows"),
                _mxarray21_,
                mclVa(r, "r"),
                _mxarray23_,
                mclVa(c, "c"),
                NULL));
        /*
         * else
         */
        } else {
            mxDestroyArray(a_);
            /*
             * delimiter = sprintf(delimiter);
             */
            mlfAssign(
              &delimiter,
              mlfSprintf(NULL, mclVa(delimiter, "delimiter"), NULL));
            /*
             * whitespace  = setdiff(sprintf(' \b\r\t'),delimiter);
             */
            mlfAssign(
              &whitespace,
              mlfNSetdiff(
                1,
                NULL,
                mlfSprintf(NULL, _mxarray25_, NULL),
                mclVa(delimiter, "delimiter"),
                NULL));
            /*
             * result  = textread(filename,'',nrows,'delimiter',delimiter,'whitespace',whitespace, ...
             */
            mlfAssign(
              &result,
              mlfNTextread(
                0,
                mclValueVarargout(),
                mclVa(filename, "filename"),
                _mxarray20_,
                mclVv(nrows, "nrows"),
                _mxarray27_,
                mclVa(delimiter, "delimiter"),
                _mxarray29_,
                mclVv(whitespace, "whitespace"),
                _mxarray21_,
                mclVa(r, "r"),
                _mxarray23_,
                mclVa(c, "c"),
                NULL));
        }
    /*
     * 'headerlines',r,'headercolumns',c);
     * end
     */
    }
    /*
     * 
     * % textread only trims leading columns, trailing columns may need clipping
     * if ~isempty(range)
     */
    if (mclNotBool(mlfIsempty(mclVa(range, "range")))) {
        /*
         * ncols = range(4) - range(2) + 1;
         */
        mlfAssign(
          &ncols,
          mclPlus(
            mclMinus(
              mclIntArrayRef1(mclVa(range, "range"), 4),
              mclIntArrayRef1(mclVa(range, "range"), 2)),
            _mxarray15_));
        /*
         * 
         * % adjust ncols if necessary
         * if ncols ~= size(result,2)
         */
        if (mclNeBool(
              mclVv(ncols, "ncols"),
              mlfSize(
                mclValueVarargout(), mclVv(result, "result"), _mxarray4_))) {
            /*
             * result= result(:,1:ncols);
             */
            mlfAssign(
              &result,
              mclArrayRef2(
                mclVv(result, "result"),
                mlfCreateColonIndex(),
                mlfColon(_mxarray15_, mclVv(ncols, "ncols"), NULL)));
        /*
         * end
         */
        }
    /*
     * end
     */
    }
    /*
     * 
     * % num rows should be correct, textread clips
     * if nrows > 0 & nrows ~= size(result,1)
     */
    {
        mxArray * a_ = mclInitialize(mclGt(mclVv(nrows, "nrows"), _mxarray10_));
        if (mlfTobool(a_)
            && mlfTobool(
                 mclAnd(
                   a_,
                   mclNe(
                     mclVv(nrows, "nrows"),
                     mlfSize(
                       mclValueVarargout(),
                       mclVv(result, "result"),
                       _mxarray15_))))) {
            mxDestroyArray(a_);
            /*
             * error('Internal size mismatch')
             */
            mlfError(_mxarray31_, NULL);
        } else {
            mxDestroyArray(a_);
        }
    /*
     * end
     */
    }
    /*
     * 
     * 
     * % When passed in 5 args, we have an offset and a range.  If the offset is
     * % not equal to the top left corner of the range the user wanted to read
     * % range Ai..Bj and start looking in that matrix at rold and cold.  For
     * % backwards compatibility we create a result the same size as the specified
     * % range and place the data in the result at the requested offset.
     * 
     * % For example, given a file with [1 2 3; 4 5 6], reading A1..C2 with offset
     * % 1,2 produces this result:
     * % 0 0 0
     * % 0 5 6
     * 
     * if nargin==5 & offset
     */
    {
        mxArray * a_ = mclInitialize(mclBoolToArray(nargin_ == 5));
        if (mlfTobool(a_) && mlfTobool(mclAnd(a_, mclVv(offset, "offset")))) {
            mxDestroyArray(a_);
            /*
             * rowIndex = rold+1:rold+nrows;
             */
            mlfAssign(
              &rowIndex,
              mlfColon(
                mclPlus(mclVv(rold, "rold"), _mxarray15_),
                mclPlus(mclVv(rold, "rold"), mclVv(nrows, "nrows")),
                NULL));
            /*
             * columnIndex = cold+1:cold+ncols;
             */
            mlfAssign(
              &columnIndex,
              mlfColon(
                mclPlus(mclVv(cold, "cold"), _mxarray15_),
                mclPlus(mclVv(cold, "cold"), mclVv(ncols, "ncols")),
                NULL));
            /*
             * if rold == 0
             */
            if (mclEqBool(mclVv(rold, "rold"), _mxarray10_)) {
                /*
                 * rowIndex = rowIndex + 1;
                 */
                mlfAssign(
                  &rowIndex, mclPlus(mclVv(rowIndex, "rowIndex"), _mxarray15_));
            /*
             * end
             */
            }
            /*
             * if cold == 0
             */
            if (mclEqBool(mclVv(cold, "cold"), _mxarray10_)) {
                /*
                 * columnIndex = columnIndex + 1;
                 */
                mlfAssign(
                  &columnIndex,
                  mclPlus(mclVv(columnIndex, "columnIndex"), _mxarray15_));
            /*
             * end
             */
            }
            /*
             * 
             * % assign into a new matrix of the desired size
             * % need to create temp matrix here cuz we want the
             * % offset region filled with zeros
             * new_result(rowIndex,columnIndex) = result;
             */
            mclArrayAssign2(
              &new_result,
              mclVv(result, "result"),
              mclVv(rowIndex, "rowIndex"),
              mclVv(columnIndex, "columnIndex"));
            /*
             * result = new_result;
             */
            mlfAssign(&result, mclVv(new_result, "new_result"));
        } else {
            mxDestroyArray(a_);
        }
    /*
     * end
     */
    }
    /*
     * 
     */
    return_:
    mclValidateOutput(result, 1, nargout_, "result", "dlmread");
    mxDestroyArray(ans);
    mxDestroyArray(fid);
    mxDestroyArray(str);
    mxDestroyArray(offset);
    mxDestroyArray(nrows);
    mxDestroyArray(rold);
    mxDestroyArray(cold);
    mxDestroyArray(whitespace);
    mxDestroyArray(ncols);
    mxDestroyArray(rowIndex);
    mxDestroyArray(columnIndex);
    mxDestroyArray(new_result);
    mxDestroyArray(range);
    mxDestroyArray(c);
    mxDestroyArray(r);
    mxDestroyArray(delimiter);
    mxDestroyArray(filename);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return result;
}
