function krelative=relcond(th,a,nn,thr,ths);
%
% RELCOND.M - Calculates the relative hydraulic conductivity as a
%    function of soil water content. Reference: van Genuchten, M. T.
%    1980. A closed-form equation for predicting the hydraulic
%    conductivity of unsaturated soils. Soil Sci. Soc. Amer.
%    J. 44, 892-898.
% INPUT: th (volumetric soil water content), a (van Genuchten paramater alpha),
%		nn (vG param. n), thr (residual water content), ths (sat. water content)
% OUTPUT: relative hydraulic conductivity [0,1]
%
thn=(th-thr)/(ths-thr);					% normalized water content
if thn>1;thn=1;end; % check for oversaturation
if thn<0;thn=0;end; % check for undervalues
k=find(thn<=0); thn(k)=zeros(size(k))+0.01; %check for undervalues
j=find(thn>=1); thn(j)=ones(size(j)); %check for oversaturation
mm=1-(1/nn);
krelative=thn.^(0.5).*(1-thn.*(thn.^(-1/mm)-1).^mm).^2;
%if thn==0; krelative=0; end;
