function varargout = RECARGA_Multiple(varargin)
% RECARGA_MULTIPLE M-file for RECARGA_Multiple.fig
%      RECARGA_MULTIPLE, by itself, creates a new RECARGA_MULTIPLE or raises the existing
%      singleton*.
%
%      H = RECARGA_MULTIPLE returns the handle to a new RECARGA_MULTIPLE or the handle to
%      the existing singleton*.
%
%      RECARGA_MULTIPLE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RECARGA_MULTIPLE.M with the given input arguments.
%
%      RECARGA_MULTIPLE('Property','Value',...) creates a new RECARGA_MULTIPLE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before RECARGA_Multiple_OpeningFunction gets called.  An
%      unrecognized property input or invalid value makes property application
%      stop.  All inputs are passed to RECARGA_Multiple_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help RECARGA_Multiple

% Last Modified by GUIDE v2.5 19-May-2004 13:54:28

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @RECARGA_Multiple_OpeningFcn, ...
                   'gui_OutputFcn',  @RECARGA_Multiple_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before RECARGA_Multiple is made visible.
function RECARGA_Multiple_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user input (see GUIDATA)
% varargin   command line arguments to RECARGA_Multiple (see VARARGIN)

% Choose default command line output for RECARGA_Multiple
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes RECARGA_Multiple wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = RECARGA_Multiple_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user input (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes during object creation, after setting all properties.
function AveET_CreateFcn(hObject, eventdata, handles)
% hObject    handle to AveET (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function AveET_Callback(hObject, eventdata, handles)
% hObject    handle to AveET (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user input (see GUIDATA)

% Hints: get(hObject,'String') returns contents of AveET as text
%        str2double(get(hObject,'String')) returns contents of AveET as a double



% --- Executes during object creation, after setting all properties.
function Input_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Input_Callback(hObject, eventdata, handles)
% hObject    handle to Input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user input (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Input as text
%        str2double(get(hObject,'String')) returns contents of Input as a double




% --- Executes during object creation, after setting all properties.
function Length_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Length (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Length_Callback(hObject, eventdata, handles)
% hObject    handle to Length (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user input (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Length as text
%        str2double(get(hObject,'String')) returns contents of Length as a double


% --- Executes during object creation, after setting all properties.
function Output_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Output (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Output_Callback(hObject, eventdata, handles)
% hObject    handle to Output (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user input (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Output as text
%        str2double(get(hObject,'String')) returns contents of Output as a double


% --- Executes during object creation, after setting all properties.
function Name_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in Input.
function Name_Callback(hObject, eventdata, handles)
% hObject    handle to Input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user input (see GUIDATA)


% Hints: contents = get(hObject,'String') returns Input contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Input


function RGCalc_Callback(hObject, eventdata, handles)
% hObject    handle to RGCalc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user input (see GUIDATA);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ZERO INITIAL OUTPUTS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Drecharge = 0; Dprecip = 0; Drunon = 0; Drunoff = 0; Devap = 0; Dudrain = 0;
inot = 0; tctpmax = 0;
unit = get(handles.Units,'Value');
Sd=.35;		% depression storage in pervious area [cm]

%avet= str2num(get(handles.AveET,'String'));
%rundays = str2num(get(handles.Length,'String'));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%DATAFILE RETRIEVAL
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fileext = '.txt';
outpre = get(handles.Output,'String');  %File to write output to
outname = strcat(outpre,fileext);
filename = get(handles.Input,'String');  %Precipitation File
infile = strcat(filename,fileext);
varpre = get(handles.Input,'String');  %File w/ Run Variables 
varfile = strcat(varpre,fileext);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Default Parameters for Multiple Runs
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Rsoilnumber = 2;  %Loamy Sand Root Zone
Ssoilnumber = 1;  %Sand Storage Zone
Krz = 10;         %Root Zone infiltration, incl. macropores
Kst = 15;         %Storage Zone infiltration
TribA = 1000;     %Default tributary area [m2]
Summary = 0;      %Do not include summary file of each run
Record = 0;       %Do not include record file for each run
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Run Modules
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
runs = dlmread(varfile,'\t',[0 0 0 0]); %runs in input file
VarMtrx = dlmread(varfile,'\t',[2 1 runs+1 11]);  %Variable matrix for runs
FileMtrx = textread(varfile,'%s',runs*12+24,'delimiter','\t');
Points = 12;
DCSumm=zeros(runs,18);
e=1;
for e=1:runs;  %Loop for number of runs
    file(e,1) = FileMtrx(e*12+12,1); filename = char(file(e,1)); 
    rundays = VarMtrx(e,1); avet = VarMtrx(e,2);
    time=rundays*24*60;			% min in data file
    stime=time/60;				% total time of simulation [h]
    infile = strcat(filename,fileext);
    nprecip=dlmread(infile,'\t',[1 0 ceil(stime)+1 2]);
	if unit == 1
        nprecip(:,2)=nprecip(:,2)./10;      %convert from [mm h-1] to [cm h-1]
        nprecip(:,3)=nprecip(:,3)./10;      %convert from [mm h-1] to [cm h-1]
        C2 = 1; C1 = 1;            %no conversion
	else
        nprecip(:,2)=nprecip(:,2).*2.54;      %convert from [in/hr] to [cm/hr]
        nprecip(:,3)=nprecip(:,3).*2.54;      %convert from [in/hr] to [cm/hr]
        C2 = 1/4046.9; C1 = 10.76;            %convert area from [m2] to [acre] and [sf]
	end

    dmin = VarMtrx(e,3);  Srz = VarMtrx(e,4); St = VarMtrx(e,5); Nsoilnumber = VarMtrx(e,6); Kcz = VarMtrx(e,7);
    Urate = VarMtrx(e,8); CN = VarMtrx(e,9); EIA = VarMtrx(e,10); Rd = VarMtrx(e,11); Arg = (Rd/100)*TribA;
    TribA = C2*1000;  %Total Tributary Area
    Arg = (Rd/100)*1000*C1;
    if unit == 1
        [Dprecip,Dimp,Dperv,Drunon,Drunoff,Devap,Drecharge,Dudrain,Dstore,maxpond,tstponded,inot] = recarga(nprecip,Sd,avet,rundays,outname,Summary,Record,dmin,Srz,St,Rsoilnumber,Ssoilnumber,Nsoilnumber,Krz,Kst,Kcz,Urate,CN,EIA,Arg,TribA);
	else
        [Dprecip,Dimp,Dperv,Drunon,Drunoff,Devap,Drecharge,Dudrain,Dstore,maxpond,tstponded,inot] = recarga_us(nprecip,Sd,avet,rundays,outname,Summary,Record,dmin,Srz,St,Rsoilnumber,Ssoilnumber,Nsoilnumber,Krz,Kst,Kcz,Urate,CN,EIA,Arg,TribA);
	end
    StayDpth=Dprecip - Drunoff - Dudrain;
    %DCSumm(e,:)=[dmin Srz VarMtrx(e,3) Nsoilnumber Kcz VarMtrx(e,6) CN EIA*100 Arg/10 Dprecip RnOnDpth RoffDpth EvapDpth Drecharge UDpth StayDpth maxpond inot];
    DCSumm(e,:)=[dmin Srz St Nsoilnumber Kcz Urate CN EIA Rd Dprecip Drunon Drunoff Devap Drecharge Dudrain StayDpth maxpond inot];
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Output Results to File                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fid=fopen(outname,'w'); fclose(fid);	% delete previous version & open
fid=fopen(outname,'at');
fprintf(fid,'Sd\t Sr\t St\t Texture\t Kn\t Ku\t CN\t EIA\t Rd\t Precip\t Runon\t Runoff\t Evap\t Recharge\t Drain\t Stayon\t maxpond(hr)\t Overflows\n');
fprintf(fid,'%6.3f\t %6.3f\t %6.3f\t %6.3f\t %6.3f\t %6.3f\t %6.3f\t %6.3f\t %6.3f\t %6.3f\t %6.3f\t %6.3f\t %6.3f\t %6.3f\t %6.3f\t %6.3f\t %6.3f\t %6.0f\n',DCSumm');
fprintf(fid,'\nFiles\n');
filenames= char(file);
fprintf(fid,'%10s \n',filenames');
fclose(fid);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% --- Executes during object creation, after setting all properties.
function Process_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Process (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

% --- Executes during object creation, after setting all properties.
function Data_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Data_Callback(hObject, eventdata, handles)
% hObject    handle to Input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user input (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Input as text
%        str2double(get(hObject,'String')) returns contents of Input as a double


% --- Executes during object creation, after setting all properties.
function Units_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Units (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in Units.
function Units_Callback(hObject, eventdata, handles)
% hObject    handle to Units (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user input (see GUIDATA)

% Hints: contents = get(hObject,'String') returns Units contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Units


