function krel=RCONDUCT(h,a,nn);
%
% RCONDUCT.M - Calculates the relative hydraulic conductivity as a
%    function of pressure head. Reference: van Genuchten, M. T.
%    1980. A closed-form equation for predicting the hydraulic
%    conductivity of unsaturated soils. Soil Sci. Soc. Amer.
%    J. 44, 892-898.
% INPUT: h (pressure head), a (van Genuchten paramater alpha=1/he, he:air-entry suction),
%		nn (vG param. n=L+1, L:pore size distribution index)
% OUTPUT: relative hydraulic conductivity [0,1]
%
p=-h;					% use absolute value of h
%p=p-1/a/2;    % correct for air-entry suction=1/a
%if p<0; p=0; end;	% check for positive pressure heads
% thus, will return Krel=Ksat for those saturated nodes
k=find(p<0);
p(k)=zeros(size(k));    % puts h=0 where h>0 saturated
mm=1-(1/nn);
b=(p.*a).^(nn-1);
c=1+(p.*a).^nn;
krel=((1-b.*c.^(-mm)).^2)./(c.^(mm/2));
