function kave=KMEAN(k1,k2,tt);
%
% KMEAN.M - Calculates the mean hydraulic conductivity 
% for 2 values, using either arithmetic, geometric or harmonic averaging
% INPUT: k1,k2 (hydraulic conductivities), tt (type of aveaging scheme),
% OUTPUT: mean hydraulic conductivity
%
if tt==1
    kk=(k1+k2)./2;              % arithmetic mean
elseif tt==2
    kk=(k1.*k2).^(1/2);         % geometric mean
elseif tt==3
    kk=(1./k1+1./k2).^(-1);     % harmonic mean
end
kave=kk;
