function [A,junk] = readjpg(filename, varargin)
%READJPG Read image data from a JPEG file.
%   A = READJPG(FILENAME) reads image data from a JPEG file.
%   A is a uint8 array that is 2-D for grayscale and 2-D for RGB
%   images. 
%
%   See also IMREAD, IMWRITE, IMFINFO.

%   Steven L. Eddins, June 1996
%   Copyright 1984-2001 The MathWorks, Inc. 
%   $Revision: 1.11 $  $Date: 2003/07/17 20:20:33 $

error(nargchk(1, 1, nargin));

[depth, msg] = jpeg_depth(filename);

if (isempty(depth))
    error(msg);
end

if (depth <= 8)
  
    A = rjpg8c(filename);
    
elseif (depth <= 12)
  
    A = rjpg12c(filename);
    
elseif (depth <= 16)
  
    A = rjpg16c(filename);
    
else
  
    error('JPEG files with %d bits are not supported.', depth)
    
end

junk = [];
