function [status,numReturnVars,warnStr] = hdfguiread(varargin)
%HDFGUIREAD Helper function for HDFTOOL to read data from an HDF/HDF-EOS
% file. This function should not be used in other M-code (scripts,
% functions, or command line).  Use HDFINFO and HDFREAD instead.

%   Copyright 1984-2002 The MathWorks, Inc.
%   $Revision: 1.4 $  $Date: 2002/06/14 20:33:33 $


import com.mathworks.toolbox.matlab.iofun.*;

map     = [];
data    = [];
status  = java.lang.Double(abstractImportPane.IMPORT_SUCCESS);
warnStr = '';
numReturnVars = java.lang.Double(1);

warnState = warning('off');
lastwarn('');

returninfo  = varargin{1};
datatype    = varargin{2};
filename    = varargin{3};
datasetname = varargin{4};
varname     = varargin{5};

%Check for valid variable name
s = isvarname(varname);
if s == 0
  status = java.lang.Double(abstractImportPane.INVALID_VARIABLE_NAME);
  return;
end

%Check if variable already exists
s = evalin('base',['exist(''' varname ''',''var'')']);
if s
  selection = questdlg(sprintf('Variable %s already exists. Overwrite?',varname),...
                       'Warning!','Yes','No','Yes');
  switch lower(selection)
   case 'yes'
   case {'no','cancel'}
    status = java.lang.Double(abstractImportPane.VARIABLE_EXISTS);
    return;
  end
end

try
  switch datatype
   case HDFImporter.SDSTYPE
    start  = [varargin{6}(:)];
    stride = [varargin{7}(:)];
    edge   = [varargin{8}(:)];
    data = hdfread(filename,...
		   datasetname,...
		   'Index',{start,stride,edge});
   case HDFImporter.VDATATYPE
    fields      = varargin{6};
    firstRecord = varargin{7};
    numRecords  = varargin{8};  
    data = hdfread(filename,datasetname,...
		   'Fields',fields,...
		   'FirstRecord',firstRecord,...
		   'NumRecords',numRecords);
   case HDFImporter.RASTER8TYPE
    mapname = varargin{6};
    s = isvarname(mapname);
    if s == 0
      status = java.lang.Double(abstractImportPane.INVALID_VARIABLE_NAME);
      return;
    end
    [data,map] = hdfread(filename,datasetname);
   case HDFImporter.RASTER24TYPE
    data = hdfread(filename,datasetname);
   case HDFImporter.POINTLEVELTYPE
    level = varargin{6};
    fields = varargin{7};
    data = hdfread(filename,datasetname,...
		   'Level',level,...
		   'Fields',fields,...
		   varargin{8:end});
   case HDFImporter.GRIDFIELDTYPE
    fields = varargin{6};
    data = hdfread(filename,...
		   datasetname,...
		   'Fields',fields,...
		   varargin{7:end});
   case HDFImporter.SWATHFIELDTYPE
    fields = varargin{6};
    data = hdfread(filename,...
		   datasetname,...
		   'Fields',...
		   fields,...
		   varargin{7:end});
  end
  assignin('base',varname,data);
  if ~isempty(map)
    assignin('base',mapname,map);
  end
catch
  status = java.lang.Double(abstractImportPane.INTERNAL_ERROR);
end

if returninfo
  hinfo = hdfquickinfo(filename,datasetname);
  assignin('base',[varname, '_info'],hinfo);
  numReturnVars = java.lang.Double(2);
end

%Check for warnings
warnStr = lastwarn;
if ~isempty(warnStr)
  status  = java.lang.Double(abstractImportPane.WARNING);
end
warning(warnState);
