/*
 * MATLAB Compiler: 3.0
 * Date: Mon Sep 20 09:40:09 2004
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-B" "sgl" "-m" "-W"
 * "main" "-L" "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "-W" "mainhg"
 * "libmwsglm.mlib" "recarga_multiple" 
 */
#include "str2rng.h"
#include "libmatlbm.h"
#include "libmmfile.h"

static mxChar _array1_[21] = { 'R', 'N', 'G', ' ', 'm', 'u', 's',
                               't', ' ', 'b', 'e', ' ', 'a', ' ',
                               's', 't', 'r', 'i', 'n', 'g', '.' };
static mxArray * _mxarray0_;
static mxArray * _mxarray2_;

static mxChar _array4_[2] = { '.', '.' };
static mxArray * _mxarray3_;
static mxArray * _mxarray5_;
static mxArray * _mxarray6_;
static mxArray * _mxarray7_;
static mxArray * _mxarray8_;

static mxChar _array10_[1] = { 'A' };
static mxArray * _mxarray9_;

void InitializeModule_str2rng(void) {
    _mxarray0_ = mclInitializeString(21, _array1_);
    _mxarray2_ = mclInitializeDoubleVector(0, 0, (double *)NULL);
    _mxarray3_ = mclInitializeString(2, _array4_);
    _mxarray5_ = mclInitializeDouble(1.0);
    _mxarray6_ = mclInitializeDouble(2.0);
    _mxarray7_ = mclInitializeDouble(26.0);
    _mxarray8_ = mclInitializeDouble(-1.0);
    _mxarray9_ = mclInitializeString(1, _array10_);
}

void TerminateModule_str2rng(void) {
    mxDestroyArray(_mxarray9_);
    mxDestroyArray(_mxarray8_);
    mxDestroyArray(_mxarray7_);
    mxDestroyArray(_mxarray6_);
    mxDestroyArray(_mxarray5_);
    mxDestroyArray(_mxarray3_);
    mxDestroyArray(_mxarray2_);
    mxDestroyArray(_mxarray0_);
}

static mxArray * Mstr2rng(int nargout_, mxArray * str);

_mexLocalFunctionTable _local_function_table_str2rng
  = { 0, (mexFunctionTableEntry *)NULL };

/*
 * The function "mlfStr2rng" contains the normal interface for the "str2rng"
 * M-function from file
 * "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\str2rng.m" (lines 1-40). This
 * function processes any input arguments and passes them to the implementation
 * version of the function, appearing above.
 */
mxArray * mlfStr2rng(mxArray * str) {
    int nargout = 1;
    mxArray * m = NULL;
    mlfEnterNewContext(0, 1, str);
    m = Mstr2rng(nargout, str);
    mlfRestorePreviousContext(0, 1, str);
    return mlfReturnValue(m);
}

/*
 * The function "mlxStr2rng" contains the feval interface for the "str2rng"
 * M-function from file
 * "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\str2rng.m" (lines 1-40). The
 * feval function calls the implementation version of str2rng through this
 * function. This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
void mlxStr2rng(int nlhs, mxArray * plhs[], int nrhs, mxArray * prhs[]) {
    mxArray * mprhs[1];
    mxArray * mplhs[1];
    int i;
    if (nlhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: str2rng Line: 1 Column: "
            "1 The function \"str2rng\" was called with mor"
            "e than the declared number of outputs (1)."),
          NULL);
    }
    if (nrhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: str2rng Line: 1 Column:"
            " 1 The function \"str2rng\" was called with m"
            "ore than the declared number of inputs (1)."),
          NULL);
    }
    for (i = 0; i < 1; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 1 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 1; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 1, mprhs[0]);
    mplhs[0] = Mstr2rng(nlhs, mprhs[0]);
    mlfRestorePreviousContext(0, 1, mprhs[0]);
    plhs[0] = mplhs[0];
}

/*
 * The function "Mstr2rng" is the implementation version of the "str2rng"
 * M-function from file
 * "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\str2rng.m" (lines 1-40). It
 * contains the actual compiled code for that M-function. It is a static
 * function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function m=str2rng(str)
 */
static mxArray * Mstr2rng(int nargout_, mxArray * str) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_str2rng);
    mxArray * m = NULL;
    mxArray * botr = NULL;
    mxArray * topl = NULL;
    mxArray * brc = NULL;
    mxArray * ulc = NULL;
    mxArray * k = NULL;
    mxArray * ans = NULL;
    mclCopyArray(&str);
    /*
     * %STR2RNG Convert spreadsheet range string to numeric array.
     * %   M = STR2RNG(RNG) converts a range in spreadsheet notation into a
     * %   numeric range M = [R1 C1 R2 C2].  
     * %
     * %   Example
     * %      str2rng('A2..AZ10') returns the vector [1 0 9 51]
     * 
     * %   Brian M. Bourgault 10/22/93
     * %   Copyright 1984-2002 The MathWorks, Inc. 
     * %   $Revision: 5.10 $  $Date: 2002/06/05 20:10:14 $
     * 
     * if ~isstr(str), error('RNG must be a string.'); end
     */
    if (mclNotBool(mlfIsstr(mclVa(str, "str")))) {
        mlfError(_mxarray0_, NULL);
    }
    /*
     * 
     * m = [];
     */
    mlfAssign(&m, _mxarray2_);
    /*
     * 
     * % convert to upper case
     * str = upper(str);
     */
    mlfAssign(&str, mlfUpper(mclVa(str, "str")));
    /*
     * 
     * % parse the upper-left and bottom-right cell locations
     * k = findstr(str,'..');
     */
    mlfAssign(&k, mlfFindstr(mclVa(str, "str"), _mxarray3_));
    /*
     * if length(k)~=1, return; end % Couldn't find '..'
     */
    if (mclLengthInt(mclVv(k, "k")) != 1) {
        goto return_;
    }
    /*
     * 
     * ulc = str(1:k-1);
     */
    mlfAssign(
      &ulc,
      mclArrayRef1(
        mclVa(str, "str"),
        mlfColon(_mxarray5_, mclMinus(mclVv(k, "k"), _mxarray5_), NULL)));
    /*
     * brc = str(k+2:end);
     */
    mlfAssign(
      &brc,
      mclArrayRef1(
        mclVa(str, "str"),
        mlfColon(
          mclPlus(mclVv(k, "k"), _mxarray6_),
          mlfEnd(mclVa(str, "str"), _mxarray5_, _mxarray5_),
          NULL)));
    /*
     * 
     * % get upper-left col
     * k = min(find(~isletter(ulc)));
     */
    mlfAssign(
      &k,
      mlfMin(
        NULL,
        mlfFind(NULL, NULL, mclNot(mlfIsletter(mclVv(ulc, "ulc")))),
        NULL,
        NULL));
    /*
     * if isempty(k) | k<2, return; end
     */
    {
        mxArray * a_ = mclInitialize(mlfIsempty(mclVv(k, "k")));
        if (mlfTobool(a_)
            || mlfTobool(mclOr(a_, mclLt(mclVv(k, "k"), _mxarray6_)))) {
            mxDestroyArray(a_);
            goto return_;
        } else {
            mxDestroyArray(a_);
        }
    }
    /*
     * topl(2) = sum(cumprod([1 26*ones(1,k-2)]).*(ulc(k-1:-1:1)-'A'+1))-1;
     */
    mclIntArrayAssign1(
      &topl,
      mclMinus(
        mlfSum(
          mclTimes(
            mlfCumprod(
              mlfHorzcat(
                _mxarray5_,
                mclMtimes(
                  _mxarray7_,
                  mlfOnes(
                    _mxarray5_, mclMinus(mclVv(k, "k"), _mxarray6_), NULL)),
                NULL),
              NULL),
            mclPlus(
              mclMinus(
                mclArrayRef1(
                  mclVv(ulc, "ulc"),
                  mlfColon(
                    mclMinus(mclVv(k, "k"), _mxarray5_),
                    _mxarray8_,
                    _mxarray5_)),
                _mxarray9_),
              _mxarray5_)),
          NULL),
        _mxarray5_),
      2);
    /*
     * topl(1) = str2double(ulc(k:end))-1;
     */
    mclIntArrayAssign1(
      &topl,
      mclMinus(
        mlfStr2double(
          mclArrayRef1(
            mclVv(ulc, "ulc"),
            mlfColon(
              mclVv(k, "k"),
              mlfEnd(mclVv(ulc, "ulc"), _mxarray5_, _mxarray5_),
              NULL))),
        _mxarray5_),
      1);
    /*
     * 
     * % get bottom-right col
     * k = min(find(~isletter(brc)));
     */
    mlfAssign(
      &k,
      mlfMin(
        NULL,
        mlfFind(NULL, NULL, mclNot(mlfIsletter(mclVv(brc, "brc")))),
        NULL,
        NULL));
    /*
     * if isempty(k) | k<2, return; end
     */
    {
        mxArray * a_ = mclInitialize(mlfIsempty(mclVv(k, "k")));
        if (mlfTobool(a_)
            || mlfTobool(mclOr(a_, mclLt(mclVv(k, "k"), _mxarray6_)))) {
            mxDestroyArray(a_);
            goto return_;
        } else {
            mxDestroyArray(a_);
        }
    }
    /*
     * botr(2) = sum(cumprod([1 26*ones(1,k-2)]).*(brc(k-1:-1:1)-'A'+1))-1;
     */
    mclIntArrayAssign1(
      &botr,
      mclMinus(
        mlfSum(
          mclTimes(
            mlfCumprod(
              mlfHorzcat(
                _mxarray5_,
                mclMtimes(
                  _mxarray7_,
                  mlfOnes(
                    _mxarray5_, mclMinus(mclVv(k, "k"), _mxarray6_), NULL)),
                NULL),
              NULL),
            mclPlus(
              mclMinus(
                mclArrayRef1(
                  mclVv(brc, "brc"),
                  mlfColon(
                    mclMinus(mclVv(k, "k"), _mxarray5_),
                    _mxarray8_,
                    _mxarray5_)),
                _mxarray9_),
              _mxarray5_)),
          NULL),
        _mxarray5_),
      2);
    /*
     * botr(1) = str2double(brc(k:end))-1;
     */
    mclIntArrayAssign1(
      &botr,
      mclMinus(
        mlfStr2double(
          mclArrayRef1(
            mclVv(brc, "brc"),
            mlfColon(
              mclVv(k, "k"),
              mlfEnd(mclVv(brc, "brc"), _mxarray5_, _mxarray5_),
              NULL))),
        _mxarray5_),
      1);
    /*
     * 
     * m=[topl botr];
     */
    mlfAssign(&m, mlfHorzcat(mclVv(topl, "topl"), mclVv(botr, "botr"), NULL));
    return_:
    mclValidateOutput(m, 1, nargout_, "m", "str2rng");
    mxDestroyArray(ans);
    mxDestroyArray(k);
    mxDestroyArray(ulc);
    mxDestroyArray(brc);
    mxDestroyArray(topl);
    mxDestroyArray(botr);
    mxDestroyArray(str);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return m;
}
