plotdata=dlmread('recharge.txt','\t',[1 2 11 9]);
plotheading=dlmread('recharge.txt','\t',[0 2 0 9]);
plotlabels=dlmread('recharge.txt','\t',[1 0 11 1]);
Rainfall= [62.4 62.4 62.4 62.4 62.4 62.4 62.4 62.4];
hold on;
for a=1:1
    CN80 = plot(plotheading,plotdata(a,:),'--r','LineWidth',1,'Tag','CN=80');
    EIALabel=num2str(plotlabels(a,2));
    text(plotheading(1,1),plotdata(a,1),EIALabel,'Color','r','HorizontalAlignment','Right','FontSize',5);
    text(plotheading(1,5),plotdata(a,5),EIALabel,'Color','r','HorizontalAlignment','Center','FontSize',5);
end
for a=6:6
    CN90 = plot(plotheading,plotdata(a,:),'-.b','LineWidth',1);
    EIALabel=num2str(plotlabels(a,2));
    text(plotheading(1,1),plotdata(a,1),EIALabel,'Color','b','HorizontalAlignment','Right','FontSize',5);
    text(plotheading(1,5),plotdata(a,5),EIALabel,'Color','b','HorizontalAlignment','Center','FontSize',5);
end
for a=11:11
    EIA100 = plot(plotheading,plotdata(a,:),'-k','LineWidth',2);
    EIALabel=num2str(plotlabels(a,2));
    text(plotheading(1,1),plotdata(a,1),EIALabel,'Color','k','HorizontalAlignment','Right','FontSize',5);
end
plot(plotheading,Rainfall,':m','LineWidth',2);
for a=2:5
    CN80 = plot(plotheading,plotdata(a,:),'--r','LineWidth',1,'Tag','CN=80');
    EIALabel=num2str(plotlabels(a,2));
    text(plotheading(1,1),plotdata(a,1),EIALabel,'Color','r','HorizontalAlignment','Right','FontSize',5);
    text(plotheading(1,5),plotdata(a,5),EIALabel,'Color','r','HorizontalAlignment','Center','FontSize',5);
end
for a=7:10
    CN90 = plot(plotheading,plotdata(a,:),'-.b','LineWidth',1);
    EIALabel=num2str(plotlabels(a,2));
    text(plotheading(1,1),plotdata(a,1),EIALabel,'Color','b','HorizontalAlignment','Right','FontSize',5);
    text(plotheading(1,5),plotdata(a,5),EIALabel,'Color','b','HorizontalAlignment','Center','FontSize',5);
end
title('Stayon Design Curves','FontSize',15,'FontWeight','bold');
xlabel('Facility Area (% of Total)','FontWeight','bold');
ylabel('Cumm. Stayon Depth (cm)','FontWeight','bold');
legend('CN=80','CN=90','100% Impervious','Rainfall',4);
    