/*
 * MATLAB Compiler: 3.0
 * Date: Mon Sep 20 09:37:12 2004
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-B" "sgl" "-m" "-W"
 * "main" "-L" "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "-W" "mainhg"
 * "libmwsglm.mlib" "RECARGA_2_3" 
 */
#include "imread.h"
#include "libmatlbm.h"
#include "libmmfile.h"
#include "libmwsglm.h"

static mxChar _array1_[2] = { '%', 's' };
static mxArray * _mxarray0_;

static mxChar _array3_[3] = { ':', '/', '/' };
static mxArray * _mxarray2_;

static mxChar _array5_[3] = { 'm', 'w', 't' };
static mxArray * _mxarray4_;

static mxChar _array7_[51] = { 'R', 'e', 'a', 'd', 'i', 'n', 'g', ' ', 'f',
                               'r', 'o', 'm', ' ', 'a', ' ', 'U', 'R', 'L',
                               ' ', 'r', 'e', 'q', 'u', 'i', 'r', 'e', 's',
                               ' ', 'a', ' ', 'J', 'a', 'v', 'a', ' ', 'V',
                               'i', 'r', 't', 'u', 'a', 'l', ' ', 'M', 'a',
                               'c', 'h', 'i', 'n', 'e', '.' };
static mxArray * _mxarray6_;

static mxChar _array9_[20] = { 'C', 'a', 'n', 0x0027, 't', ' ',
                               'r', 'e', 'a', 'd', ' ', 'U', 'R',
                               'L', ' ', '"', '%', 's', '"', '.' };
static mxArray * _mxarray8_;

static mxChar _array11_[1] = { 'r' };
static mxArray * _mxarray10_;
static mxArray * _mxarray12_;

static mxChar _array14_[68] = { 'C', 'a', 'n', 0x0027, 't', ' ', 'o', 'p',
                                'e', 'n', ' ', 'f', 'i', 'l', 'e', ' ', '"',
                                '%', 's', '"', ' ', 'f', 'o', 'r', ' ', 'r',
                                'e', 'a', 'd', 'i', 'n', 'g', ';', 0x005c,
                                'n', 'y', 'o', 'u', ' ', 'm', 'a', 'y', ' ',
                                'n', 'o', 't', ' ', 'h', 'a', 'v', 'e', ' ',
                                'r', 'e', 'a', 'd', ' ', 'p', 'e', 'r', 'm',
                                'i', 's', 's', 'i', 'o', 'n', '.' };
static mxArray * _mxarray13_;

static mxChar _array16_[25] = { 'F', 'i', 'l', 'e', ' ', '"', '%', 's', '"',
                                ' ', 'd', 'o', 'e', 's', ' ', 'n', 'o', 't',
                                ' ', 'e', 'x', 'i', 's', 't', '.' };
static mxArray * _mxarray15_;

static mxChar _array18_[36] = { 'U', 'n', 'a', 'b', 'l', 'e', ' ', 't', 'o',
                                ' ', 'd', 'e', 't', 'e', 'r', 'm', 'i', 'n',
                                'e', ' ', 't', 'h', 'e', ' ', 'f', 'i', 'l',
                                'e', ' ', 'f', 'o', 'r', 'm', 'a', 't', '.' };
static mxArray * _mxarray17_;

static mxChar _array20_[70] = { 'C', 'o', 'u', 'l', 'd', 'n', 0x0027, 't',
                                ' ', 'f', 'i', 'n', 'd', ' ', 'f', 'o', 'r',
                                'm', 'a', 't', ' ', '%', 's', ' ', 'i', 'n',
                                ' ', 't', 'h', 'e', ' ', 'f', 'o', 'r', 'm',
                                'a', 't', ' ', 'r', 'e', 'g', 'i', 's', 't',
                                'r', 'y', '.', ' ', ' ', 'S', 'e', 'e', ' ',
                                '"', 'h', 'e', 'l', 'p', ' ', 'i', 'm', 'f',
                                'o', 'r', 'm', 'a', 't', 's', '"', '.' };
static mxArray * _mxarray19_;
static mxArray * _mxarray21_;

static mxChar _array23_[1] = { '.' };
static mxArray * _mxarray22_;

static mxChar _array25_[57] = { 'N', 'o', ' ', 'r', 'e', 'a', 'd', 'i', 'n',
                                'g', ' ', 'f', 'u', 'n', 'c', 't', 'i', 'o',
                                'n', ' ', 'f', 'o', 'r', ' ', 'f', 'o', 'r',
                                'm', 'a', 't', ' ', '%', 's', '.', ' ', ' ',
                                'S', 'e', 'e', ' ', '"', 'h', 'e', 'l', 'p',
                                ' ', 'i', 'm', 'f', 'o', 'r', 'm', 'a', 't',
                                's', '"', '.' };
static mxArray * _mxarray24_;
static mxArray * _mxarray26_;

static mxChar _array28_[33] = { 'C', 'a', 'n', 0x0027, 't', ' ', 'd', 'e',
                                'l', 'e', 't', 'e', ' ', 't', 'e', 'm', 'p',
                                'o', 'r', 'a', 'r', 'y', ' ', 'f', 'i', 'l',
                                'e', ' ', '"', '%', 's', '"', '.' };
static mxArray * _mxarray27_;
static mxArray * _mxarray29_;
static mxArray * _mxarray30_;
static mxArray * _mxarray31_;

static mxChar _array33_[24] = { 'T', 'o', 'o', ' ', 'f', 'e', 'w', ' ',
                                'i', 'n', 'p', 'u', 't', ' ', 'a', 'r',
                                'g', 'u', 'm', 'e', 'n', 't', 's', '.' };
static mxArray * _mxarray32_;
static mxArray * _mxarray34_;
static mxArray * _mxarray35_;

void InitializeModule_imread(void) {
    _mxarray0_ = mclInitializeString(2, _array1_);
    _mxarray2_ = mclInitializeString(3, _array3_);
    _mxarray4_ = mclInitializeString(3, _array5_);
    _mxarray6_ = mclInitializeString(51, _array7_);
    _mxarray8_ = mclInitializeString(20, _array9_);
    _mxarray10_ = mclInitializeString(1, _array11_);
    _mxarray12_ = mclInitializeDouble(-1.0);
    _mxarray13_ = mclInitializeString(68, _array14_);
    _mxarray15_ = mclInitializeString(25, _array16_);
    _mxarray17_ = mclInitializeString(36, _array18_);
    _mxarray19_ = mclInitializeString(70, _array20_);
    _mxarray21_ = mclInitializeDoubleVector(0, 0, (double *)NULL);
    _mxarray22_ = mclInitializeString(1, _array23_);
    _mxarray24_ = mclInitializeString(57, _array25_);
    _mxarray26_ = mclInitializeDouble(1.0);
    _mxarray27_ = mclInitializeString(33, _array28_);
    _mxarray29_ = mclInitializeCharVector(0, 0, (mxChar *)NULL);
    _mxarray30_ = mclInitializeCellVector(0, 0, (mxArray * *)NULL);
    _mxarray31_ = mclInitializeDouble(0.0);
    _mxarray32_ = mclInitializeString(24, _array33_);
    _mxarray34_ = mclInitializeDouble(2.0);
    _mxarray35_ = mclInitializeDouble(3.0);
}

void TerminateModule_imread(void) {
    mxDestroyArray(_mxarray35_);
    mxDestroyArray(_mxarray34_);
    mxDestroyArray(_mxarray32_);
    mxDestroyArray(_mxarray31_);
    mxDestroyArray(_mxarray30_);
    mxDestroyArray(_mxarray29_);
    mxDestroyArray(_mxarray27_);
    mxDestroyArray(_mxarray26_);
    mxDestroyArray(_mxarray24_);
    mxDestroyArray(_mxarray22_);
    mxDestroyArray(_mxarray21_);
    mxDestroyArray(_mxarray19_);
    mxDestroyArray(_mxarray17_);
    mxDestroyArray(_mxarray15_);
    mxDestroyArray(_mxarray13_);
    mxDestroyArray(_mxarray12_);
    mxDestroyArray(_mxarray10_);
    mxDestroyArray(_mxarray8_);
    mxDestroyArray(_mxarray6_);
    mxDestroyArray(_mxarray4_);
    mxDestroyArray(_mxarray2_);
    mxDestroyArray(_mxarray0_);
}

static void mlfImread_delete_download(mxArray * filename);
static void mlxImread_delete_download(int nlhs,
                                      mxArray * plhs[],
                                      int nrhs,
                                      mxArray * prhs[]);
static mxArray * mlfImread_parse_inputs(mxArray * * format,
                                        mxArray * * extraArgs,
                                        mxArray * * msg,
                                        ...);
static void mlxImread_parse_inputs(int nlhs,
                                   mxArray * plhs[],
                                   int nrhs,
                                   mxArray * prhs[]);
static mxArray * Mimread(mxArray * * map,
                         mxArray * * alpha,
                         int nargout_,
                         mxArray * varargin);
static void Mimread_delete_download(mxArray * filename);
static mxArray * Mimread_parse_inputs(mxArray * * format,
                                      mxArray * * extraArgs,
                                      mxArray * * msg,
                                      int nargout_,
                                      mxArray * varargin);

static mexFunctionTableEntry local_function_table_[2]
  = { { "delete_download", mlxImread_delete_download, 1, 0, NULL },
      { "parse_inputs", mlxImread_parse_inputs, -1, 4, NULL } };

_mexLocalFunctionTable _local_function_table_imread
  = { 2, local_function_table_ };

/*
 * The function "mlfNImread" contains the nargout interface for the "imread"
 * M-function from file "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\imread.m"
 * (lines 1-297). This interface is only produced if the M-function uses the
 * special variable "nargout". The nargout interface allows the number of
 * requested outputs to be specified via the nargout argument, as opposed to
 * the normal interface which dynamically calculates the number of outputs
 * based on the number of non-NULL inputs it receives. This function processes
 * any input arguments and passes them to the implementation version of the
 * function, appearing above.
 */
mxArray * mlfNImread(int nargout, mxArray * * map, mxArray * * alpha, ...) {
    mxArray * varargin = NULL;
    mxArray * X = NULL;
    mxArray * map__ = NULL;
    mxArray * alpha__ = NULL;
    mlfVarargin(&varargin, alpha, 0);
    mlfEnterNewContext(2, -1, map, alpha, varargin);
    X = Mimread(&map__, &alpha__, nargout, varargin);
    mlfRestorePreviousContext(2, 0, map, alpha);
    mxDestroyArray(varargin);
    if (map != NULL) {
        mclCopyOutputArg(map, map__);
    } else {
        mxDestroyArray(map__);
    }
    if (alpha != NULL) {
        mclCopyOutputArg(alpha, alpha__);
    } else {
        mxDestroyArray(alpha__);
    }
    return mlfReturnValue(X);
}

/*
 * The function "mlfImread" contains the normal interface for the "imread"
 * M-function from file "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\imread.m"
 * (lines 1-297). This function processes any input arguments and passes them
 * to the implementation version of the function, appearing above.
 */
mxArray * mlfImread(mxArray * * map, mxArray * * alpha, ...) {
    mxArray * varargin = NULL;
    int nargout = 1;
    mxArray * X = NULL;
    mxArray * map__ = NULL;
    mxArray * alpha__ = NULL;
    mlfVarargin(&varargin, alpha, 0);
    mlfEnterNewContext(2, -1, map, alpha, varargin);
    if (map != NULL) {
        ++nargout;
    }
    if (alpha != NULL) {
        ++nargout;
    }
    X = Mimread(&map__, &alpha__, nargout, varargin);
    mlfRestorePreviousContext(2, 0, map, alpha);
    mxDestroyArray(varargin);
    if (map != NULL) {
        mclCopyOutputArg(map, map__);
    } else {
        mxDestroyArray(map__);
    }
    if (alpha != NULL) {
        mclCopyOutputArg(alpha, alpha__);
    } else {
        mxDestroyArray(alpha__);
    }
    return mlfReturnValue(X);
}

/*
 * The function "mlfVImread" contains the void interface for the "imread"
 * M-function from file "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\imread.m"
 * (lines 1-297). The void interface is only produced if the M-function uses
 * the special variable "nargout", and has at least one output. The void
 * interface function specifies zero output arguments to the implementation
 * version of the function, and in the event that the implementation version
 * still returns an output (which, in MATLAB, would be assigned to the "ans"
 * variable), it deallocates the output. This function processes any input
 * arguments and passes them to the implementation version of the function,
 * appearing above.
 */
void mlfVImread(mxArray * synthetic_varargin_argument, ...) {
    mxArray * varargin = NULL;
    mxArray * X = NULL;
    mxArray * map = NULL;
    mxArray * alpha = NULL;
    mlfVarargin(&varargin, synthetic_varargin_argument, 1);
    mlfEnterNewContext(0, -1, varargin);
    X = Mimread(&map, &alpha, 0, synthetic_varargin_argument);
    mlfRestorePreviousContext(0, 0);
    mxDestroyArray(varargin);
    mxDestroyArray(X);
    mxDestroyArray(map);
}

/*
 * The function "mlxImread" contains the feval interface for the "imread"
 * M-function from file "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\imread.m"
 * (lines 1-297). The feval function calls the implementation version of imread
 * through this function. This function processes any input arguments and
 * passes them to the implementation version of the function, appearing above.
 */
void mlxImread(int nlhs, mxArray * plhs[], int nrhs, mxArray * prhs[]) {
    mxArray * mprhs[1];
    mxArray * mplhs[3];
    int i;
    if (nlhs > 3) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: imread Line: 1 Column: "
            "1 The function \"imread\" was called with mor"
            "e than the declared number of outputs (3)."),
          NULL);
    }
    for (i = 0; i < 3; ++i) {
        mplhs[i] = NULL;
    }
    mlfEnterNewContext(0, 0);
    mprhs[0] = NULL;
    mlfAssign(&mprhs[0], mclCreateVararginCell(nrhs, prhs));
    mplhs[0] = Mimread(&mplhs[1], &mplhs[2], nlhs, mprhs[0]);
    mlfRestorePreviousContext(0, 0);
    plhs[0] = mplhs[0];
    for (i = 1; i < 3 && i < nlhs; ++i) {
        plhs[i] = mplhs[i];
    }
    for (; i < 3; ++i) {
        mxDestroyArray(mplhs[i]);
    }
    mxDestroyArray(mprhs[0]);
}

/*
 * The function "mlfImread_delete_download" contains the normal interface for
 * the "imread/delete_download" M-function from file
 * "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\imread.m" (lines 297-311).
 * This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
static void mlfImread_delete_download(mxArray * filename) {
    mlfEnterNewContext(0, 1, filename);
    Mimread_delete_download(filename);
    mlfRestorePreviousContext(0, 1, filename);
}

/*
 * The function "mlxImread_delete_download" contains the feval interface for
 * the "imread/delete_download" M-function from file
 * "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\imread.m" (lines 297-311). The
 * feval function calls the implementation version of imread/delete_download
 * through this function. This function processes any input arguments and
 * passes them to the implementation version of the function, appearing above.
 */
static void mlxImread_delete_download(int nlhs,
                                      mxArray * plhs[],
                                      int nrhs,
                                      mxArray * prhs[]) {
    mxArray * mprhs[1];
    int i;
    if (nlhs > 0) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: imread/delete_download Line: 297 C"
            "olumn: 1 The function \"imread/delete_download\" was cal"
            "led with more than the declared number of outputs (0)."),
          NULL);
    }
    if (nrhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: imread/delete_download Line: 297 C"
            "olumn: 1 The function \"imread/delete_download\" was cal"
            "led with more than the declared number of inputs (1)."),
          NULL);
    }
    for (i = 0; i < 1 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 1; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 1, mprhs[0]);
    Mimread_delete_download(mprhs[0]);
    mlfRestorePreviousContext(0, 1, mprhs[0]);
}

/*
 * The function "mlfImread_parse_inputs" contains the normal interface for the
 * "imread/parse_inputs" M-function from file
 * "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\imread.m" (lines 311-354).
 * This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
static mxArray * mlfImread_parse_inputs(mxArray * * format,
                                        mxArray * * extraArgs,
                                        mxArray * * msg,
                                        ...) {
    mxArray * varargin = NULL;
    int nargout = 1;
    mxArray * filename = NULL;
    mxArray * format__ = NULL;
    mxArray * extraArgs__ = NULL;
    mxArray * msg__ = NULL;
    mlfVarargin(&varargin, msg, 0);
    mlfEnterNewContext(3, -1, format, extraArgs, msg, varargin);
    if (format != NULL) {
        ++nargout;
    }
    if (extraArgs != NULL) {
        ++nargout;
    }
    if (msg != NULL) {
        ++nargout;
    }
    filename
      = Mimread_parse_inputs(
          &format__, &extraArgs__, &msg__, nargout, varargin);
    mlfRestorePreviousContext(3, 0, format, extraArgs, msg);
    mxDestroyArray(varargin);
    if (format != NULL) {
        mclCopyOutputArg(format, format__);
    } else {
        mxDestroyArray(format__);
    }
    if (extraArgs != NULL) {
        mclCopyOutputArg(extraArgs, extraArgs__);
    } else {
        mxDestroyArray(extraArgs__);
    }
    if (msg != NULL) {
        mclCopyOutputArg(msg, msg__);
    } else {
        mxDestroyArray(msg__);
    }
    return mlfReturnValue(filename);
}

/*
 * The function "mlxImread_parse_inputs" contains the feval interface for the
 * "imread/parse_inputs" M-function from file
 * "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\imread.m" (lines 311-354). The
 * feval function calls the implementation version of imread/parse_inputs
 * through this function. This function processes any input arguments and
 * passes them to the implementation version of the function, appearing above.
 */
static void mlxImread_parse_inputs(int nlhs,
                                   mxArray * plhs[],
                                   int nrhs,
                                   mxArray * prhs[]) {
    mxArray * mprhs[1];
    mxArray * mplhs[4];
    int i;
    if (nlhs > 4) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: imread/parse_inputs Line: 311 Co"
            "lumn: 1 The function \"imread/parse_inputs\" was calle"
            "d with more than the declared number of outputs (4)."),
          NULL);
    }
    for (i = 0; i < 4; ++i) {
        mplhs[i] = NULL;
    }
    mlfEnterNewContext(0, 0);
    mprhs[0] = NULL;
    mlfAssign(&mprhs[0], mclCreateVararginCell(nrhs, prhs));
    mplhs[0]
      = Mimread_parse_inputs(&mplhs[1], &mplhs[2], &mplhs[3], nlhs, mprhs[0]);
    mlfRestorePreviousContext(0, 0);
    plhs[0] = mplhs[0];
    for (i = 1; i < 4 && i < nlhs; ++i) {
        plhs[i] = mplhs[i];
    }
    for (; i < 4; ++i) {
        mxDestroyArray(mplhs[i]);
    }
    mxDestroyArray(mprhs[0]);
}

/*
 * The function "Mimread" is the implementation version of the "imread"
 * M-function from file "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\imread.m"
 * (lines 1-297). It contains the actual compiled code for that M-function. It
 * is a static function and must only be called from one of the interface
 * functions, appearing below.
 */
/*
 * function [X, map, alpha] = imread(varargin)
 */
static mxArray * Mimread(mxArray * * map,
                         mxArray * * alpha,
                         int nargout_,
                         mxArray * varargin) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_imread);
    mxArray * X = NULL;
    mxArray * p = NULL;
    mxArray * fmt_s = NULL;
    mxArray * fid = NULL;
    mxArray * url = NULL;
    mxArray * ans = NULL;
    mxArray * msg = NULL;
    mxArray * extraArgs = NULL;
    mxArray * format = NULL;
    mxArray * filename = NULL;
    mclCopyArray(&varargin);
    /*
     * %IMREAD Read image from graphics file.
     * %   A = IMREAD(FILENAME,FMT) reads a grayscale or color image from the
     * %   file specified by the string FILENAME, where the string FMT specifies
     * %   the format of the file.  See the reference page, or the output of the
     * %   function IMFORMATS, for a list of supported formats.  If the file is
     * %   not in the current directory or in a directory in the MATLAB path,
     * %   specify the full pathname of the location on your system.  If IMREAD
     * %   cannot find a file named FILENAME, it looks for a file named
     * %   FILENAME.FMT.
     * %
     * %   IMREAD returns the image data in the array A.  If the file contains a
     * %   grayscale image, A is a two-dimensional (M-by-N) array.  If the file
     * %   contains a color image, A is a three-dimensional (M-by-N-by-3)
     * %   array.  The class of the returned array depends on the data type used
     * %   by the file format.
     * %
     * %   For most file formats, the color image data returned uses the RGB
     * %   color space.  For TIFF files, however, IMREAD can return color data
     * %   that uses the RGB, CIELAB, ICCLAB, or CMYK color spaces.  If the
     * %   color image uses the CMYK color space, A is an M-by-N-by-4 array.
     * %   See the reference page for more information about reading TIFF files
     * %   that use these color spaces.
     * %
     * %   [X,MAP] = IMREAD(FILENAME,FMT) reads the indexed image in FILENAME
     * %   into X and its associated colormap into MAP. Colormap values in the
     * %   image file are automatically rescaled into the range [0,1]. 
     * %
     * %   [...] = IMREAD(FILENAME) attempts to infer the format of the file
     * %   from its content.
     * %
     * %   [...] = IMREAD(URL,...) reads the image from an Internet URL.  The
     * %   URL must include the protocol type (e.g., "http://"). 
     * %
     * %   Data types
     * %   ----------
     * %   In most of the image file formats supported by IMREAD, pixels are
     * %   stored using 8 or fewer bits per color plane.  If the file contains
     * %   only 1 bit per pixel, the class of the output (A or X) is logical.
     * %   When reading other files with 8 or fewer bits per color plane, the
     * %   class of the output is uint8.  IMREAD also supports reading
     * %   16-bit-per-pixel data from BMP, PNG, JPEG, and TIFF files, as well as
     * %   12-bit JPEG files. For 12-bit JPEG and 16-bit JPEG, PNG, and TIFF
     * %   image files, the class of the output (A or X) is uint16 and for
     * %   16-bit BMP image files, the class of the output is uint8. 
     * %
     * %   TIFF-specific syntaxes
     * %   ----------------------
     * %   [...] = IMREAD(...,IDX) reads in one image from a multi-image TIFF
     * %   file.  IDX is an integer value that specifies the order that the
     * %   image appears in the file. For example, if IDX is 3, IMREAD reads the
     * %   third image in the file.  If you omit this argument, IMREAD reads the
     * %   first image in the file.  
     * %
     * %   PNG-specific syntaxes
     * %   ---------------------
     * %   [...] = IMREAD(...,'BackgroundColor',BG) composites any transparent
     * %   pixels in the input image against the color specified in BG.  If BG
     * %   is 'none', then no compositing is performed. Otherwise, if the input
     * %   image is indexed, BG should be an integer in the range [1,P] where P
     * %   is the colormap length. If the input image is grayscale, BG should be
     * %   an integer in the range [0,1].  If the input image is RGB, BG should
     * %   be a three-element vector whose values are in the range [0,1]. The
     * %   string 'BackgroundColor' may be abbreviated.  
     * %
     * %   If the ALPHA output argument is used (see below), then BG defaults to
     * %   'none' if not specified by the user. Otherwise, if the PNG file
     * %   contains a background color chunk, that color is used as the default
     * %   value for BG. If ALPHA is not used and the file does not contain a
     * %   background color chunk, then the default value for BG is 1 for
     * %   indexed images; 0 for grayscale images; and [0 0 0] for RGB images.  
     * %
     * %   [A,MAP,ALPHA] = IMREAD(...) returns the alpha channel if one is
     * %   present; otherwise ALPHA is [].  Note that MAP may be empty if the
     * %   file contains a grayscale or truecolor image.
     * %
     * %   HDF-specific syntaxes
     * %   ---------------------
     * %   [...] = IMREAD(...,REF) reads in one image from a multi-image HDF
     * %   file.  REF is an integer value that specifies the reference number
     * %   used to identify the image. For example, if REF is 12, IMREAD reads
     * %   the image whose reference number is 12.  (Note that in an HDF file
     * %   the reference numbers do not necessarily correspond with the order of
     * %   the images in the file.  You can use IMFINFO to match up image order
     * %   with reference number.)  If you omit this argument, IMREAD reads the
     * %   first image in the file. 
     * %
     * %   ICO- and CUR-specific syntaxes
     * %   ------------------------------
     * %   [...] = IMREAD(...,IDX) reads in one image from a multi-image icon or
     * %   cursor file.  IDX is an integer value that specifies the order that
     * %   the image appears in the file. For example, if IDX is 3, IMREAD reads
     * %   the third image in the file.  If you omit this argument, IMREAD reads
     * %   the first image in the file. 
     * %
     * %   [A,MAP,ALPHA] = IMREAD(...) returns the AND mask for the resource, which
     * %   can be used to determine the transparency information.  For cursor
     * %   files, this mask may contain the only useful data.
     * %
     * %   GIF-specific syntaxes
     * %   ---------------------
     * %   [...] = IMREAD(...,IDX) reads in one or more frames from a multiframe
     * %   (i.e., animated) GIF file.  IDX must be an integer scalar or vector of
     * %   integer values.  For example, if IDX is 3, IMREAD reads the third image
     * %   in the file.  If IDX is 1:5, only the first five frames will be
     * %   returned.
     * %
     * %   [...] = IMREAD(...,'Frames',IDX) is the same as the syntax above except
     * %   that IDX can be 'all'.  In this case, all of the frames are read and
     * %   returned in the order that they appear in the file.
     * %
     * %   Note: Because of the way that GIF files are structured, all of the
     * %   frames must be read when a particular frame is requested.  Consequently,
     * %   it is much faster to specify a vector of frames or 'all' for IDX than to
     * %   call IMREAD in a loop when reading multiple frames from the same GIF
     * %   file.
     * %
     * %   Supported file types
     * %   --------------------
     * %   JPEG  Any baseline JPEG image; JPEG images with some
     * %         commonly used extensions; 8-bit and 12-bit lossy
     * %         compressed RGB and grayscale images; 8-bit and 12-bit
     * %         lossless compressed RGB images; 8-bit, 12-bit, and
     * %         16-bit lossless compressed grayscale images
     * %
     * %   TIFF  Any baseline TIFF image, including 1-bit, 8-bit, and
     * %         24-bit uncompressed images; 1-bit, 8-bit, and 24-bit
     * %         images with packbits compression; 1-bit images with
     * %         CCITT compression; also, 16-bit grayscale, 16-bit
     * %         indexed, and 48-bit RGB images
     * %
     * %   GIF   Any 1-bit to 8-bit GIF image
     * %
     * %   BMP   1-bit, 4-bit, 8-bit, 16-bit, 24-bit, and 32-bit uncompressed
     * %         images; 4-bit and 8-bit run-length encoded (RLE) images
     * %
     * %   PNG   Any PNG image, including 1-bit, 2-bit, 4-bit, 8-bit,
     * %         and 16-bit grayscale images; 8-bit and 16-bit
     * %         indexed images; 24-bit and 48-bit RGB images
     * %
     * %   HDF   8-bit raster image datasets, with or without an
     * %         associated colormap; 24-bit raster image datasets
     * %
     * %   PCX   1-bit, 8-bit, and 24-bit images
     * %
     * %   XWD   1-bit and 8-bit ZPixmaps; XYBitmaps; 1-bit XYPixmaps
     * %
     * %   ICO   1-bit, 4-bit, and 8-bit uncompressed images
     * %
     * %   CUR   1-bit, 4-bit, and 8-bit uncompressed images
     * %
     * %   RAS   Any RAS image, including 1-bit bitmap, 8-bit indexed,
     * %         24-bit truecolor and 32-bit truecolor with alpha.
     * %
     * %   PBM   Any 1-bit PBM image.  Raw (binary) or ASCII (plain) encoded.
     * %
     * %   PGM   Any standard PGM image.  ASCII (plain) encoded with
     * %         arbitrary color depth.  Raw (binary) encoded with up
     * %         to 16 bits per gray value.
     * %
     * %   PPM   Any standard PPM image.  ASCII (plain) encoded with
     * %         arbitrary color depth. Raw (binary) encoded with up
     * %         to 16 bits per color component.
     * %
     * %   See also IMFINFO, IMWRITE, IMFORMATS, FREAD, IMAGE, DOUBLE, UINT8.
     * 
     * %   Copyright 1984-2002 The MathWorks, Inc.
     * %   $Revision: 1.33 $  $Date: 2003/07/17 21:14:32 $
     * 
     * [filename, format, extraArgs, msg] = parse_inputs(varargin{:});
     */
    mlfAssign(
      &filename,
      mlfImread_parse_inputs(
        &format,
        &extraArgs,
        &msg,
        mlfIndexRef(mclVa(varargin, "varargin"), "{?}", mlfCreateColonIndex()),
        NULL));
    /*
     * if (~isempty(msg))
     */
    if (mclNotBool(mlfIsempty(mclVv(msg, "msg")))) {
        /*
         * error('%s', msg);
         */
        mlfError(_mxarray0_, mclVv(msg, "msg"), NULL);
    /*
     * end
     */
    }
    /*
     * 
     * % Download remote file.
     * if (strfind(filename, '://'))
     */
    if (mlfTobool(mlfStrfind(mclVv(filename, "filename"), _mxarray2_))) {
        /*
         * 
         * url = true;
         */
        mlfAssign(&url, mlfTrue(NULL));
        /*
         * 
         * if (~usejava('mwt'))
         */
        if (mclNotBool(mlfUsejava(_mxarray4_))) {
            /*
             * error('Reading from a URL requires a Java Virtual Machine.')
             */
            mlfError(_mxarray6_, NULL);
        /*
         * end
         */
        }
        /*
         * 
         * try
         */
        mlfTry {
            /*
             * filename = urlwrite(filename, tempname);
             */
            mlfAssign(
              &filename,
              mlfNUrlwrite(
                1,
                NULL,
                mclVv(filename, "filename"),
                mlfTempname(),
                NULL,
                NULL));
        /*
         * catch
         */
        } mlfCatch {
            /*
             * error('Can''t read URL "%s".', filename);
             */
            mlfError(_mxarray8_, mclVv(filename, "filename"), NULL);
        /*
         * end
         */
        } mlfEndCatch
    /*
     * 
     * else
     */
    } else {
        /*
         * 
         * url = false;
         */
        mlfAssign(&url, mlfFalse(NULL));
    /*
     * 
     * end
     */
    }
    /*
     * 
     * 
     * if (isempty(format))
     */
    if (mlfTobool(mlfIsempty(mclVv(format, "format")))) {
        /*
         * % The format was not specified explicitly.
         * 
         * % Verify that the file exists.
         * fid = fopen(filename, 'r');
         */
        mlfAssign(
          &fid,
          mlfFopen(NULL, NULL, mclVv(filename, "filename"), _mxarray10_, NULL));
        /*
         * if (fid == -1)
         */
        if (mclEqBool(mclVv(fid, "fid"), _mxarray12_)) {
            /*
             * 
             * if ~isempty(dir(filename))
             */
            if (mclNotBool(
                  mlfIsempty(mlfNDir(1, mclVv(filename, "filename"))))) {
                /*
                 * error(['Can''t open file "%s" for reading;\nyou' ...
                 */
                mlfError(_mxarray13_, mclVv(filename, "filename"), NULL);
            /*
             * ' may not have read permission.'], ...
             * filename);
             * else
             */
            } else {
                /*
                 * error('File "%s" does not exist.', filename);
                 */
                mlfError(_mxarray15_, mclVv(filename, "filename"), NULL);
            /*
             * end
             */
            }
        /*
         * 
         * else
         */
        } else {
            /*
             * % File exists.  Get full filename.
             * filename = fopen(fid);
             */
            mlfAssign(
              &filename, mlfFopen(NULL, NULL, mclVv(fid, "fid"), NULL, NULL));
            /*
             * fclose(fid);
             */
            mclAssignAns(&ans, mlfFclose(mclVv(fid, "fid")));
        /*
         * end
         */
        }
        /*
         * 
         * % Try to determine the file type.
         * format = imftype(filename);
         */
        mlfAssign(
          &format, mlfIofun_private_imftype(mclVv(filename, "filename")));
        /*
         * 
         * if (isempty(format))
         */
        if (mlfTobool(mlfIsempty(mclVv(format, "format")))) {
            /*
             * error('Unable to determine the file format.');
             */
            mlfError(_mxarray17_, NULL);
        /*
         * end
         */
        }
    /*
     * 
     * else
     */
    } else {
        /*
         * % The format was specified explicitly.
         * 
         * % Verify that the file exists.
         * fid = fopen(filename, 'r');
         */
        mlfAssign(
          &fid,
          mlfFopen(NULL, NULL, mclVv(filename, "filename"), _mxarray10_, NULL));
        /*
         * if (fid == -1)
         */
        if (mclEqBool(mclVv(fid, "fid"), _mxarray12_)) {
            /*
             * % Couldn't open using the given filename; search for a
             * % file with an appropriate extension.
             * fmt_s = imformats(format);
             */
            mlfAssign(
              &fmt_s,
              mlfNImformats(
                0, mclValueVarargout(), mclVv(format, "format"), NULL));
            /*
             * 
             * if (isempty(fmt_s))
             */
            if (mlfTobool(mlfIsempty(mclVv(fmt_s, "fmt_s")))) {
                /*
                 * error(['Couldn''t find format %s in the format registry.' ...
                 */
                mlfError(_mxarray19_, mclVv(format, "format"), NULL);
            /*
             * '  See "help imformats".'], format);
             * end
             */
            }
            /*
             * 
             * for p = 1:length(fmt_s.ext)
             */
            {
                int v_ = mclForIntStart(1);
                int e_
                  = mclForIntEnd(
                      mclFeval(
                        mclValueVarargout(),
                        mlxLength,
                        mlfIndexRef(mclVv(fmt_s, "fmt_s"), ".ext"),
                        NULL));
                if (v_ > e_) {
                    mlfAssign(&p, _mxarray21_);
                } else {
                    /*
                     * fid = fopen([filename '.' fmt_s.ext{p}]);
                     * 
                     * if (fid ~= -1)
                     * % The file was found.  Don't continue searching.
                     * break
                     * end
                     * end
                     */
                    for (; ; ) {
                        mlfAssign(
                          &fid,
                          mlfFopen(
                            NULL,
                            NULL,
                            mlfHorzcat(
                              mclVv(filename, "filename"),
                              _mxarray22_,
                              mlfIndexRef(
                                mclVv(fmt_s, "fmt_s"),
                                ".ext{?}",
                                mlfScalar(v_)),
                              NULL),
                            NULL,
                            NULL));
                        if (mclNeBool(mclVv(fid, "fid"), _mxarray12_)) {
                            break;
                        }
                        if (v_ == e_) {
                            break;
                        }
                        ++v_;
                    }
                    mlfAssign(&p, mlfScalar(v_));
                }
            }
        /*
         * end
         */
        }
        /*
         * 
         * if (fid == -1)
         */
        if (mclEqBool(mclVv(fid, "fid"), _mxarray12_)) {
            /*
             * if ~isempty(dir(filename))
             */
            if (mclNotBool(
                  mlfIsempty(mlfNDir(1, mclVv(filename, "filename"))))) {
                /*
                 * error(['Can''t open file "%s" for reading;\nyou' ...
                 */
                mlfError(_mxarray13_, mclVv(filename, "filename"), NULL);
            /*
             * ' may not have read permission.'], ...
             * filename);
             * else
             */
            } else {
                /*
                 * error('File "%s" does not exist.', filename);
                 */
                mlfError(_mxarray15_, mclVv(filename, "filename"), NULL);
            /*
             * end
             */
            }
        /*
         * else
         */
        } else {
            /*
             * filename = fopen(fid);
             */
            mlfAssign(
              &filename, mlfFopen(NULL, NULL, mclVv(fid, "fid"), NULL, NULL));
            /*
             * fclose(fid);
             */
            mclAssignAns(&ans, mlfFclose(mclVv(fid, "fid")));
        /*
         * end
         */
        }
    /*
     * 
     * end
     */
    }
    /*
     * 
     * % Get format details.
     * fmt_s = imformats(format);
     */
    mlfAssign(
      &fmt_s,
      mlfNImformats(0, mclValueVarargout(), mclVv(format, "format"), NULL));
    /*
     * 
     * % Verify that a read function exists
     * if (isempty(fmt_s.read))
     */
    if (mlfTobool(
          mclFeval(
            mclValueVarargout(),
            mlxIsempty,
            mlfIndexRef(mclVv(fmt_s, "fmt_s"), ".read"),
            NULL))) {
        /*
         * error('No reading function for format %s.  See "help imformats".', ...
         */
        mlfError(
          _mxarray24_,
          mlfIndexRef(mclVv(fmt_s, "fmt_s"), ".ext{?}", _mxarray26_),
          NULL);
    /*
     * fmt_s.ext{1});
     * end
     */
    }
    /*
     * 
     * if ((fmt_s.alpha) & (nargout == 3))
     */
    {
        mxArray * a_
          = mclInitialize(mlfIndexRef(mclVv(fmt_s, "fmt_s"), ".alpha"));
        if (mlfTobool(a_)
            && mlfTobool(mclAnd(a_, mclBoolToArray(nargout_ == 3)))) {
            mxDestroyArray(a_);
            /*
             * 
             * % Use the alpha channel.
             * [X, map, alpha] = feval(fmt_s.read, filename, extraArgs{:});
             */
            mlfFeval(
              mlfVarargout(&X, map, alpha, NULL),
              mlfIndexRef(mclVv(fmt_s, "fmt_s"), ".read"),
              mclVv(filename, "filename"),
              mlfIndexRef(
                mclVv(extraArgs, "extraArgs"), "{?}", mlfCreateColonIndex()),
              NULL);
        /*
         * 
         * else
         */
        } else {
            mxDestroyArray(a_);
            /*
             * 
             * % Alpha channel is not requested or is not applicable.
             * alpha = [];
             */
            mlfAssign(alpha, _mxarray21_);
            /*
             * [X, map] = feval(fmt_s.read, filename, extraArgs{:});
             */
            mlfFeval(
              mlfVarargout(&X, map, NULL),
              mlfIndexRef(mclVv(fmt_s, "fmt_s"), ".read"),
              mclVv(filename, "filename"),
              mlfIndexRef(
                mclVv(extraArgs, "extraArgs"), "{?}", mlfCreateColonIndex()),
              NULL);
        }
    /*
     * 
     * end
     */
    }
    /*
     * 
     * % Delete temporary file from Internet download.
     * if (url)
     */
    if (mlfTobool(mclVv(url, "url"))) {
        /*
         * delete_download(filename);
         */
        mlfImread_delete_download(mclVv(filename, "filename"));
    /*
     * end
     */
    }
    mclValidateOutput(X, 1, nargout_, "X", "imread");
    mclValidateOutput(*map, 2, nargout_, "map", "imread");
    mclValidateOutput(*alpha, 3, nargout_, "alpha", "imread");
    mxDestroyArray(filename);
    mxDestroyArray(format);
    mxDestroyArray(extraArgs);
    mxDestroyArray(msg);
    mxDestroyArray(ans);
    mxDestroyArray(url);
    mxDestroyArray(fid);
    mxDestroyArray(fmt_s);
    mxDestroyArray(p);
    mxDestroyArray(varargin);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return X;
    /*
     * 
     * 
     * 
     * %%%
     * %%% Function delete_download
     * %%%
     */
}

/*
 * The function "Mimread_delete_download" is the implementation version of the
 * "imread/delete_download" M-function from file
 * "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\imread.m" (lines 297-311). It
 * contains the actual compiled code for that M-function. It is a static
 * function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function delete_download(filename)
 */
static void Mimread_delete_download(mxArray * filename) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_imread);
    mxArray * ans = NULL;
    mclCopyArray(&filename);
    /*
     * 
     * try
     */
    mlfTry {
        /*
         * delete(filename);
         */
        mlfDelete(mclVa(filename, "filename"), NULL);
    /*
     * catch
     */
    } mlfCatch {
        /*
         * warning('Can''t delete temporary file "%s".', filename)
         */
        mclPrintAns(
          &ans,
          mlfNWarning(0, NULL, _mxarray27_, mclVa(filename, "filename"), NULL));
    /*
     * end
     */
    } mlfEndCatch
    mxDestroyArray(ans);
    mxDestroyArray(filename);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    /*
     * 
     * 
     * 
     * 
     * %%%
     * %%% Function parse_inputs
     * %%%
     */
}

/*
 * The function "Mimread_parse_inputs" is the implementation version of the
 * "imread/parse_inputs" M-function from file
 * "g:\win32\matlab_r13_sp1\toolbox\matlab\iofun\imread.m" (lines 311-354). It
 * contains the actual compiled code for that M-function. It is a static
 * function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function [filename, format, extraArgs, msg] = ...
 */
static mxArray * Mimread_parse_inputs(mxArray * * format,
                                      mxArray * * extraArgs,
                                      mxArray * * msg,
                                      int nargout_,
                                      mxArray * varargin) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_imread);
    int nargin_ = mclNargin(-1, varargin, NULL);
    mxArray * filename = NULL;
    mxArray * fmt_s = NULL;
    mclCopyArray(&varargin);
    /*
     * parse_inputs(varargin)
     * 
     * filename = '';
     */
    mlfAssign(&filename, _mxarray29_);
    /*
     * format = '';
     */
    mlfAssign(format, _mxarray29_);
    /*
     * extraArgs = {};
     */
    mlfAssign(extraArgs, _mxarray30_);
    /*
     * msg = '';
     */
    mlfAssign(msg, _mxarray29_);
    /*
     * 
     * % Parse arguments based on their number.
     * switch(nargin)
     */
    {
        mxArray * v_ = mclInitialize(mlfScalar(nargin_));
        if (mclSwitchCompare(v_, _mxarray31_)) {
            /*
             * case 0
             * 
             * % Not allowed.
             * msg = 'Too few input arguments.';
             */
            mlfAssign(msg, _mxarray32_);
        /*
         * return;
         * 
         * case 1
         */
        } else if (mclSwitchCompare(v_, _mxarray26_)) {
            /*
             * 
             * % Filename only.
             * filename = varargin{1};
             */
            mlfAssign(
              &filename,
              mlfIndexRef(mclVa(varargin, "varargin"), "{?}", _mxarray26_));
        /*
         * 
         * otherwise
         */
        } else {
            /*
             * 
             * % Filename and format or other arguments.
             * filename = varargin{1};
             */
            mlfAssign(
              &filename,
              mlfIndexRef(mclVa(varargin, "varargin"), "{?}", _mxarray26_));
            /*
             * 
             * % Check whether second argument is a format.
             * if (ischar(varargin{2}))
             */
            if (mlfTobool(
                  mclFeval(
                    mclValueVarargout(),
                    mlxIschar,
                    mlfIndexRef(
                      mclVa(varargin, "varargin"), "{?}", _mxarray34_),
                    NULL))) {
                /*
                 * fmt_s = imformats(varargin{2});
                 */
                mlfAssign(
                  &fmt_s,
                  mlfNImformats(
                    0,
                    mclValueVarargout(),
                    mlfIndexRef(
                      mclVa(varargin, "varargin"), "{?}", _mxarray34_),
                    NULL));
            /*
             * else
             */
            } else {
                /*
                 * fmt_s = struct([]);
                 */
                mlfAssign(&fmt_s, mlfStruct(_mxarray21_, NULL));
            /*
             * end
             */
            }
            /*
             * 
             * if (~isempty(fmt_s))
             */
            if (mclNotBool(mlfIsempty(mclVv(fmt_s, "fmt_s")))) {
                /*
                 * % The argument matches a format.
                 * format = varargin{2};
                 */
                mlfAssign(
                  format,
                  mlfIndexRef(mclVa(varargin, "varargin"), "{?}", _mxarray34_));
                /*
                 * extraArgs = varargin(3:end);
                 */
                mlfAssign(
                  extraArgs,
                  mclArrayRef1(
                    mclVa(varargin, "varargin"),
                    mlfColon(
                      _mxarray35_,
                      mlfEnd(
                        mclVa(varargin, "varargin"), _mxarray26_, _mxarray26_),
                      NULL)));
            /*
             * else
             */
            } else {
                /*
                 * % The argument begins the format-specific parameters.
                 * extraArgs = varargin(2:end);
                 */
                mlfAssign(
                  extraArgs,
                  mclArrayRef1(
                    mclVa(varargin, "varargin"),
                    mlfColon(
                      _mxarray34_,
                      mlfEnd(
                        mclVa(varargin, "varargin"), _mxarray26_, _mxarray26_),
                      NULL)));
            /*
             * end
             */
            }
        /*
         * 
         * end
         */
        }
        mxDestroyArray(v_);
    }
    mclValidateOutput(filename, 1, nargout_, "filename", "imread/parse_inputs");
    mclValidateOutput(*format, 2, nargout_, "format", "imread/parse_inputs");
    mclValidateOutput(
      *extraArgs, 3, nargout_, "extraArgs", "imread/parse_inputs");
    mclValidateOutput(*msg, 4, nargout_, "msg", "imread/parse_inputs");
    mxDestroyArray(fmt_s);
    mxDestroyArray(varargin);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return filename;
}
