function theta=THETAH(h,a,nn,nsat,nres,ss,hh0);
%
% thetah.M - Calculates the volumetric moisture content as a function
%    of pressure head. Reference: van Genuchten, M. T. 1980. A 
%    closed-form equation for predicting the hydraulic conductivity 
%    of unsaturated soils. Soil Sci. Soc. Amer. J. 44, 892-898.
% INPUT: h (pressure head), a (van Genuchten parameter alpha),
%		nn (vG param. n), nsat (sat. water content), nres (residual)
% OUTPUT: soil water content
%
%p=abs(h);					% use absolute value of h
%p0=abs(hh0);
%p=p-1/a/2;    % correct for air-entry suction=1/a
%if p<0; p=0; end;	% check for positive pressure heads
% thus, will return sat. moisture content for those saturated nodes
x=h>hh0;    % ones where hi>hh0
%p(k)=zeros(size(k));    % puts h=0 where h>0 saturated
mm=1-(1/nn);
b=(1+(-a.*h).^nn).^mm;
b0=(1+(-a.*hh0).^nn).^mm;
theta=(1-x).*(nres+(nsat-nres)./b)+x.*(nres+(nsat-nres)./b0+ss.*(h-hh0));