function varargout = RECARGA_2_3(varargin)
% RECARGA_2_3 M-file for RECARGA_2_3.fig
%      RECARGA_2_3, by itself, creates a new RECARGA_2_3 or raises the existing
%      singleton*.
%
%      H = RECARGA_2_3 returns the handle to a new RECARGA_2_3 or the handle to
%      the existing singleton*.
%
%      RECARGA_2_3('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RECARGA_2_3.M with the given input arguments.
%
%      RECARGA_2_3('Property','Value',...) creates a new RECARGA_2_3 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before RECARGA_2_3_OpeningFunction gets called.  An
%      unrecognized property input or invalid value makes property application
%      stop.  All inputs are passed to RECARGA_2_3_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help RECARGA_2_3

% Last Modified by GUIDE v2.5 19-Aug-2004 13:28:53

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @RECARGA_2_3_OpeningFcn, ...
                   'gui_OutputFcn',  @RECARGA_2_3_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before RECARGA_2_3 is made visible.
function RECARGA_2_3_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to RECARGA_2_3 (see VARARGIN)

% Choose default command line output for RECARGA_2_3
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

prevunit=1;

% Image Files Code
set(hObject, 'Units', 'normalized');
handles.RGpic = imread([filesep 'RG.jpg']); % Read the image file RGpic.jpg
info = imfinfo([filesep 'RG.jpg']); % Determine the size of the image file
position = get(hObject, 'Position');
axes(handles.ICON);
image(handles.RGpic)
set(handles.ICON,'Visible', 'off');

handles.RGprof = imread([filesep 'RGProf.jpg']); % Read the image file RGpic.jpg
info = imfinfo([filesep 'RGProf.jpg']); % Determine the size of the image file
position = get(hObject, 'Position');
axes(handles.Profile);
image(handles.RGprof)
set(handles.Profile,'Visible', 'off');
% UIWAIT makes RECARGA_2_3 wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = RECARGA_2_3_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

function Process_Callback(hObject, eventdata, handles)
% hObject    handle to Process (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Process as text
%        str2double(get(hObject,'String')) returns contents of Process as a double


% --- Executes during object creation, after setting all properties.
function Progress_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Progress (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Progress_Callback(hObject, eventdata, handles)
% hObject    handle to Progress (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Progress as text
%        str2double(get(hObject,'String')) returns contents of Progress as a double


% --- Executes during object creation, after setting all properties.
function Runon_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Runon (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Runon_Callback(hObject, eventdata, handles)
% hObject    handle to Runon (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Runon as text
%        str2double(get(hObject,'String')) returns contents of Runon as a double


% --- Executes during object creation, after setting all properties.
function Runoff_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Runoff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Runoff_Callback(hObject, eventdata, handles)
% hObject    handle to Runoff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Runoff as text
%        str2double(get(hObject,'String')) returns contents of Runoff as a double


% --- Executes during object creation, after setting all properties.
function Recharge_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Recharge (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Recharge_Callback(hObject, eventdata, handles)
% hObject    handle to Recharge (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Recharge as text
%        str2double(get(hObject,'String')) returns contents of Recharge as a double


% --- Executes during object creation, after setting all properties.
function Evap_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Evap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Evap_Callback(hObject, eventdata, handles)
% hObject    handle to Evap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Evap as text
%        str2double(get(hObject,'String')) returns contents of Evap as a double


% --- Executes during object creation, after setting all properties.
function Storage_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Storage (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Storage_Callback(hObject, eventdata, handles)
% hObject    handle to Storage (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Storage as text
%        str2double(get(hObject,'String')) returns contents of Storage as a double


% --- Executes during object creation, after setting all properties.
function Prunon_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prunon (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Prunon_Callback(hObject, eventdata, handles)
% hObject    handle to Prunon (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prunon as text
%        str2double(get(hObject,'String')) returns contents of Prunon as a double


% --- Executes during object creation, after setting all properties.
function Prunoff_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prunoff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Prunoff_Callback(hObject, eventdata, handles)
% hObject    handle to Prunoff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prunoff as text
%        str2double(get(hObject,'String')) returns contents of Prunoff as a double


% --- Executes during object creation, after setting all properties.
function Precharge_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Precharge (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Precharge_Callback(hObject, eventdata, handles)
% hObject    handle to Precharge (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Precharge as text
%        str2double(get(hObject,'String')) returns contents of Precharge as a double


% --- Executes during object creation, after setting all properties.
function Pevap_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Pevap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Pevap_Callback(hObject, eventdata, handles)
% hObject    handle to Pevap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Pevap as text
%        str2double(get(hObject,'String')) returns contents of Pevap as a double


% --- Executes during object creation, after setting all properties.
function maxpond_CreateFcn(hObject, eventdata, handles)
% hObject    handle to maxpond (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function maxpond_Callback(hObject, eventdata, handles)
% hObject    handle to maxpond (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of maxpond as text
%        str2double(get(hObject,'String')) returns contents of maxpond as a double


% --- Executes during object creation, after setting all properties.
function maxwilt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to maxwilt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function maxwilt_Callback(hObject, eventdata, handles)
% hObject    handle to maxwilt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of maxwilt as text
%        str2double(get(hObject,'String')) returns contents of maxwilt as a double


% --- Executes during object creation, after setting all properties.
function tpond_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tpond (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function tpond_Callback(hObject, eventdata, handles)
% hObject    handle to tpond (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tpond as text
%        str2double(get(hObject,'String')) returns contents of tpond as a double


% --- Executes during object creation, after setting all properties.
function OFtimes_CreateFcn(hObject, eventdata, handles)
% hObject    handle to OFtimes (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function OFtimes_Callback(hObject, eventdata, handles)
% hObject    handle to OFtimes (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of OFtimes as text
%        str2double(get(hObject,'String')) returns contents of OFtimes as a double


% --- Executes during object creation, after setting all properties.
function ImpA_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ImpA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function ImpA_Callback(hObject, eventdata, handles)
% hObject    handle to ImpA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ImpA as text
%        str2double(get(hObject,'String')) returns contents of ImpA as a double


% --- Executes during object creation, after setting all properties.
function CN_CreateFcn(hObject, eventdata, handles)
% hObject    handle to CN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function CN_Callback(hObject, eventdata, handles)
% hObject    handle to CN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of CN as text
%        str2double(get(hObject,'String')) returns contents of CN as a double


% --- Executes during object creation, after setting all properties.
function ImpVol_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ImpVol (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function ImpVol_Callback(hObject, eventdata, handles)
% hObject    handle to ImpVol (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ImpVol as text
%        str2double(get(hObject,'String')) returns contents of ImpVol as a double


% --- Executes during object creation, after setting all properties.
function PervVol_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PervVol (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function PervVol_Callback(hObject, eventdata, handles)
% hObject    handle to PervVol (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PervVol as text
%        str2double(get(hObject,'String')) returns contents of PervVol as a double


% --- Executes during object creation, after setting all properties.
function ImpDpth_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ImpDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function ImpDpth_Callback(hObject, eventdata, handles)
% hObject    handle to ImpDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ImpDpth as text
%        str2double(get(hObject,'String')) returns contents of ImpDpth as a double


% --- Executes during object creation, after setting all properties.
function PervDpth_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PervDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function PervDpth_Callback(hObject, eventdata, handles)
% hObject    handle to PervDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PervDpth as text
%        str2double(get(hObject,'String')) returns contents of PervDpth as a double


% --- Executes during object creation, after setting all properties.
function RoffDpth_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RoffDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function RoffDpth_Callback(hObject, eventdata, handles)
% hObject    handle to RoffDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of RoffDpth as text
%        str2double(get(hObject,'String')) returns contents of RoffDpth as a double


% --- Executes during object creation, after setting all properties.
function RchrgDpth_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RchrgDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function RchrgDpth_Callback(hObject, eventdata, handles)
% hObject    handle to RchrgDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of RchrgDpth as text
%        str2double(get(hObject,'String')) returns contents of RchrgDpth as a double


% --- Executes during object creation, after setting all properties.
function EvapDpth_CreateFcn(hObject, eventdata, handles)
% hObject    handle to EvapDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function EvapDpth_Callback(hObject, eventdata, handles)
% hObject    handle to EvapDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of EvapDpth as text
%        str2double(get(hObject,'String')) returns contents of EvapDpth as a double


% --- Executes during object creation, after setting all properties.
function RnOnDpth_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RnOnDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function RnOnDpth_Callback(hObject, eventdata, handles)
% hObject    handle to RnOnDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of RnOnDpth as text
%        str2double(get(hObject,'String')) returns contents of RnOnDpth as a double


% --- Executes during object creation, after setting all properties.
function UdVol_CreateFcn(hObject, eventdata, handles)
% hObject    handle to UdVol (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function UdVol_Callback(hObject, eventdata, handles)
% hObject    handle to UdVol (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of UdVol as text
%        str2double(get(hObject,'String')) returns contents of UdVol as a double


% --- Executes during object creation, after setting all properties.
function UdFrac_CreateFcn(hObject, eventdata, handles)
% hObject    handle to UdFrac (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function UdFrac_Callback(hObject, eventdata, handles)
% hObject    handle to UdFrac (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of UdFrac as text
%        str2double(get(hObject,'String')) returns contents of UdFrac as a double


% --- Executes during object creation, after setting all properties.
function UdDpth_CreateFcn(hObject, eventdata, handles)
% hObject    handle to UdDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function UdDpth_Callback(hObject, eventdata, handles)
% hObject    handle to UdDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of UdDpth as text
%        str2double(get(hObject,'String')) returns contents of UdDpth as a double


% --- Executes during object creation, after setting all properties.
function UFlow_CreateFcn(hObject, eventdata, handles)
% hObject    handle to UFlow (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function UFlow_Callback(hObject, eventdata, handles)
% hObject    handle to UFlow (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of UFlow as text
%        str2double(get(hObject,'String')) returns contents of UFlow as a double

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Determine underdrain size
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Arg = str2num(get(handles.RGArea,'String'));  %Bioretention Cell Size 
dmin = str2num(get(handles.Sd,'String'));
Srz = str2num(get(handles.Srz,'String'));
UD_Flow = str2double(get(hObject,'String'));
Umax = (UD_Flow/100)*(Arg/3600); %Max. Underdrain flow [m3/sec]
hmax = (dmin + Srz)/100;  %Max. Head on underdrain [m]
Co = 0.62; g=9.81; pi=3.1457; %constants
udiam = 2*sqrt((Umax/(Co*pi*sqrt(2*g*hmax))))*1000;  %underdrain diameter [m]
unit = get(handles.Units,'Value');
if unit == 2
    g = 32.18503937007874015748031496063;
    hmax = (dmin + Srz)/12; %Max. Head on underdrain [ft]
    Umax = (UD_Flow/12)*(Arg/3600); %Max. Underdrain flow [ft3/sec]
    udiam = 2*sqrt((Umax/(Co*pi*sqrt(2*g*hmax))))*12;  %underdrain diameter [ft]
end

set(handles.Udiam,'String',num2str(udiam));  %display resultant underdrain diam in figure


% --- Executes during object creation, after setting all properties.
function BasinArea_CreateFcn(hObject, eventdata, handles)
% hObject    handle to BasinArea (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function BasinArea_Callback(hObject, eventdata, handles)
% hObject    handle to BasinArea (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of BasinArea as text
%        str2double(get(hObject,'String')) returns contents of BasinArea as a double


% --- Executes during object creation, after setting all properties.
function Udiam_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Udiam (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Udiam_Callback(hObject, eventdata, handles)
% hObject    handle to Udiam (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Udiam as text
%        str2double(get(hObject,'String')) returns contents of Udiam as a double


% --- Executes on button press in clear.
Arg = str2num(get(handles.RGArea,'String'));  %Bioretention Cell Size 
dmin = str2num(get(handles.Sd,'String'));
Srz = str2num(get(handles.Srz,'String'));
Diam = str2num(get(hObject,'String'));
hmax = (dmin + Srz)/100;  %Max. Head on underdrain [m]
Co = 0.62; g=9.81; pi=3.1457; %constants
Uarea = pi*(Diam/2000)^2;  %underdrain area [m]
Umax = sqrt(2*g*hmax)*Co*Uarea;  %Max. Underdrain flow [m3/sec]
UD_Flow = Umax/(Arg/3600)*100;
unit = get(handles.Units,'Value');
if unit == 2
    g = 32.18503937007874015748031496063;
    hmax = (dmin + Srz)/12; %Max. Head on underdrain [ft]
    Uarea = pi*(Diam/24)^2; 
    Umax = sqrt(2*g*hmax)*Co*Uarea; %Max. Underdrain flow [ft3/sec]
    UD_Flow = Umax/(Arg/3600)*12; 
end

set(handles.UFlow,'String',num2str(UD_Flow));  %display resultant underdrain diam in figure

% --- Executes during object creation, after setting all properties.
function AveET_CreateFcn(hObject, eventdata, handles)
% hObject    handle to AveET (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function AveET_Callback(hObject, eventdata, handles)
% hObject    handle to AveET (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of AveET as text
%        str2double(get(hObject,'String')) returns contents of AveET as a double





% --- Executes during object creation, after setting all properties.
function Sd_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Sd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Sd_Callback(hObject, eventdata, handles)
% hObject    handle to Sd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Sd as text
%        str2double(get(hObject,'String')) returns contents of Sd as a double


% --- Executes during object creation, after setting all properties.
function Srz_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Srz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Srz_Callback(hObject, eventdata, handles)
% hObject    handle to Srz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Srz as text
%        str2double(get(hObject,'String')) returns contents of Srz as a double


% --- Executes during object creation, after setting all properties.
function St_CreateFcn(hObject, eventdata, handles)
% hObject    handle to St (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function St_Callback(hObject, eventdata, handles)
% hObject    handle to St (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of St as text
%        str2double(get(hObject,'String')) returns contents of St as a double



% --- Executes during object creation, after setting all properties.
function Ksat_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Ksat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Ksat_Callback(hObject, eventdata, handles)
% hObject    handle to Ksat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Ksat as text
%        str2double(get(hObject,'String')) returns contents of Ksat as a double



% --- Executes during object creation, after setting all properties.
function Input_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Input_Callback(hObject, eventdata, handles)
% hObject    handle to Input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Input as text
%        str2double(get(hObject,'String')) returns contents of Input as a double


% --- Executes during object creation, after setting all properties.
function edit9_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit9_Callback(hObject, eventdata, handles)
% hObject    handle to edit9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit9 as text
%        str2double(get(hObject,'String')) returns contents of edit9 as a double


% --- Executes during object creation, after setting all properties.
function popupmenu1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in popupmenu1.
function popupmenu1_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu1


% --- Executes during object creation, after setting all properties.
function Length_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Length (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Length_Callback(hObject, eventdata, handles)
% hObject    handle to Length (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Length as text
%        str2double(get(hObject,'String')) returns contents of Length as a double


% --- Executes during object creation, after setting all properties.
function Output_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Output (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Output_Callback(hObject, eventdata, handles)
% hObject    handle to Output (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Output as text
%        str2double(get(hObject,'String')) returns contents of Output as a double


% --- Executes during object creation, after setting all properties.
function Name_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in Input.
function Name_Callback(hObject, eventdata, handles)
% hObject    handle to Input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% Hints: contents = get(hObject,'String') returns Input contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Input



% --- Executes during object creation, after setting all properties.
function RGArea_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RGArea (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.

if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function RGArea_Callback(hObject, eventdata, handles)
% hObject    handle to RGArea (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of RGArea as text
%        str2double(get(hObject,'String')) returns contents of RGArea as a double
% --- Executes on button press in RGCalc.
%%GOHERE
Arg = str2num(get(hObject,'String'));  %Bioretention Cell Size 
dmin = str2num(get(handles.Sd,'String'));
Srz = str2num(get(handles.Srz,'String'));
UD_Flow = str2double(get(handles.UFlow,'String'));
Umax = (UD_Flow/100)*(Arg/3600); %Max. Underdrain flow [m3/sec]
hmax = (dmin + Srz)/100;  %Max. Head on underdrain [m]
Co = 0.62; g=9.81; pi=3.1457; %constants
udiam = 2*sqrt((Umax/(Co*pi*sqrt(2*g*hmax))))*1000;  %underdrain diameter [m]
unit = get(handles.Units,'Value');
if unit == 2
    g = 32.18503937007874015748031496063;
    hmax = (dmin + Srz)/12; %Max. Head on underdrain [ft]
    Umax = (UD_Flow/12)*(Arg/3600); %Max. Underdrain flow [ft3/sec]
    udiam = 2*sqrt((Umax/(Co*pi*sqrt(2*g*hmax))))*12;  %underdrain diameter [ft]
end

set(handles.Udiam,'String',num2str(udiam));  %display resultant underdrain diam in figure


function RGCalc_Callback(hObject, eventdata, handles)
% hObject    handle to RGCalc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% UNITS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
unit = get(handles.Units,'Value');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% TRIBUTARY BASIN PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
EIA = str2num(get(handles.ImpA,'String'));  %Percent impervious area
Arg = str2num(get(handles.RGArea,'String'));  %Bioretention Cell Size 
TribA = str2num(get(handles.BasinArea,'String'));  %Total Tributary Area
CN = str2num(get(handles.CN,'String'));
%g=9.8;		% acceleration of gravity [m/s2]
Sd=.35;		% depression storage in pervious area [cm]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% EVAPORATION PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
avet= str2num(get(handles.AveET,'String'));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SOIL SENSITIVITY PARAMETERS:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if unit ==1
    soilsdata=dlmread('soilsDNR.txt','\t',[0 1 10 4]);
else
    soilsdata=dlmread('soilsUS.txt','\t',[0 1 10 4]);
end
soilnames=textread('soilslist.txt','%s','delimiter','\n','whitespace','');
Nsoilnumber = get(handles.NativeTexture,'Value');
Rsoilnumber = get(handles.RootTexture,'Value');
Ssoilnumber = get(handles.StorageTexture,'Value');
NTexture = soilnames(Nsoilnumber,1);
STexture = soilnames(Ssoilnumber,1);
RTexture = soilnames(Rsoilnumber,1);
dmin = str2num(get(handles.Sd,'String'));
St = str2num(get(handles.St,'String'));  %Storage Zone thickness
Srz = str2num(get(handles.Srz,'String'));  %Root Zone thickness
Scz = 10;  %Default value for Control Zone thickness
Kcz= str2num(get(handles.Ksat,'String'));  %Control Zone Sat. Hydraulic Conductivity
Krz = str2num(get(handles.Kroot,'String'));  %Root Zone Sat. Hydraulic Conductivity
Kst = str2num(get(handles.Kstore,'String')); %Storage Zone Sat. Hydraulic Conductivity
if St==0    %Allow for no storage by dividing control zone into two equal layers
    St=5;  
    Scz=5;
    Kst = Kcz;
    STexture = NTexture;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  UNDERDRAIN SIZING
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Urate = str2num(get(handles.UFlow,'String'));
Umax = (Urate/100)*(Arg/3600); %Max. Underdrain flow [m3/sec]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MODELING PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% TEMPORAL:
HydroCalc = get(handles.SimType,'Value');  %1: Continuous, 2: Single Event, 3: User Type
if HydroCalc == 2
    rundays = 3;
else rundays = str2num(get(handles.Length,'String'));
end
time=rundays*24*60;			% min in data file
dt=15;						% TIME STEP [min]
stime=time/60;				% total time of simulation [h]
dt=dt/60;					% TIME STEP [h]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%DATAFILE RETRIEVAL
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
outname = get(handles.Output,'String');
Summary = get(handles.Summary,'Value');
Record = get(handles.Record,'Value');
fileext = '.txt';
if HydroCalc == 1
    filename = get(handles.Input,'String');
    infile = strcat(filename,fileext);
    nprecip=dlmread(infile,'\t',[1 0 ceil(stime)+1 2]);
    if unit ==1 
        nprecip(:,2)=nprecip(:,2)./10;      %convert Precip from [mm h-1] to [cm h-1]
        nprecip(:,3)=nprecip(:,3)./10;      %convert Evap from [mm h-1] to [cm h-1]
    else
    end
elseif HydroCalc == 2
    PptType = get(handles.PptType,'Value'); %1: Type I, 2: Type IA, 3: Type II, 4: Type III
    if PptType == 1
        PptName = 'TypeI';
    elseif PptType ==2 
        PptName = 'TypeIA'; 
    elseif PptType == 3 
        PptName = 'TypeII';
    else 
        PptName = 'TypeIII';
    end
    PptDepth = str2num(get(handles.PptDepth,'String'));
    PptFile = num2str(strcat(PptName,'.txt'));
    nprecip = dlmread(PptFile,'\t',[1 0 ceil(stime)+1 2]);
    nprecip(:,2)=nprecip(:,2).*PptDepth;      %convert Precip from [mm h-1] to [cm h-1]
    nprecip(:,3)=nprecip(:,3).*avet/24;      %convert Evap from [mm h-1] to [cm h-1]
else
    Sd = 0;  
    EIA = 100;
    filename = get(handles.Input,'String');
    infile = strcat(filename,fileext);
    nprecip=dlmread(infile,'\t',[1 0 ceil(stime)+1 2]);
   
    if unit == 1
        nprecip(:,2)=nprecip(:,2)./10;      %convert Precip from [mm h-1] to [cm h-1]
        nprecip(:,3)=nprecip(:,3)./10;      %convert Evap from [mm h-1] to [cm h-1]
    else
    end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Run Modules
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if unit == 1
    [Dprecip,Dimp,Dperv,Drunon,Drunoff,Devap,Drecharge,Dudrain,Dstore,maxpond,tstponded,inot] = recarga(nprecip,Sd,avet,rundays,outname,Summary,Record,dmin,Srz,St,Rsoilnumber,Ssoilnumber,Nsoilnumber,Krz,Kst,Kcz,Urate,CN,EIA,Arg,TribA);
else
    nprecip(:,2)=nprecip(:,2).*2.54; nprecip(:,3)=nprecip(:,3).*2.54;
    [Dprecip,Dimp,Dperv,Drunon,Drunoff,Devap,Drecharge,Dudrain,Dstore,maxpond,tstponded,inot] = recarga_us(nprecip,Sd,avet,rundays,outname,Summary,Record,dmin,Srz,St,Rsoilnumber,Ssoilnumber,Nsoilnumber,Krz,Kst,Kcz,Urate,CN,EIA,Arg,TribA);
end
Dstay = Dprecip - Drunoff- Dudrain;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Display Results
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(handles.Precharge,'String',num2str(100*Drecharge/Dprecip));
set(handles.Prunon,'String',num2str(100*Drunon/Dprecip));
set(handles.Prunoff,'String',num2str(100*Drunoff/Dprecip));
set(handles.RoffDpth,'String',num2str(Drunoff));
set(handles.RnOnDpth,'String',num2str(Drunon));
set(handles.RchrgDpth,'String',num2str(Drecharge));
set(handles.EvapDpth,'String',num2str(Devap));
set(handles.Pevap,'String',num2str(100*Devap/Dprecip));
set(handles.maxpond,'String',num2str(maxpond));
set(handles.OFtimes,'String',num2str(inot));
set(handles.tpond,'String',num2str(tstponded));
set(handles.ImpDpth,'String',num2str(Dimp));
set(handles.PervDpth,'String',num2str(Dperv));
set(handles.UdDpth,'String',num2str(Dudrain));
set(handles.UdFrac,'String',num2str(100*Dudrain/Dprecip));
set(handles.SMdepth,'String',num2str(Dstore));
set(handles.SMpercent,'String',num2str(100*Dstore/Dprecip));
set(handles.StayDpth,'String',num2str(Dstay));
set(handles.Stayper,'String',num2str(100*Dstay/Dprecip));
set(handles.precip,'String',num2str(Dprecip));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% --- Executes during object creation, after setting all properties.
function Process_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Process (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function clear_Callback(hObject, eventdata, handles)
% hObject    handle to clear (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.Precharge,'String','0');
set(handles.Prunon,'String','0');
set(handles.Prunoff,'String','0');
set(handles.RoffDpth,'String','0');
set(handles.RnOnDpth,'String','0');
set(handles.RchrgDpth,'String','0');
set(handles.EvapDpth,'String','0');
set(handles.Pevap,'String','0');
set(handles.maxpond,'String','0');
set(handles.tpond,'String','0');
set(handles.OFtimes,'String','0');
set(handles.ImpDpth,'String','0');
set(handles.PervDpth,'String','0');
set(handles.UdDpth,'String','0');
set(handles.UdFrac,'String','0');
set(handles.SMdepth,'String','0');
set(handles.SMpercent,'String','0');
set(handles.StayDpth,'String','0');
set(handles.Stayper,'String','0');
set(handles.precip,'String','0');

% --- Executes during object creation, after setting all properties.
function RootTexture_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RootTexture (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in RootTexture.
function RootTexture_Callback(hObject, eventdata, handles)
% hObject    handle to RootTexture (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns RootTexture contents as cell array
%        contents{get(hObject,'Value')} returns selected item from RootTexture


% --- Executes during object creation, after setting all properties.
function StorageTexture_CreateFcn(hObject, eventdata, handles)
% hObject    handle to StorageTexture (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in StorageTexture.
function StorageTexture_Callback(hObject, eventdata, handles)
% hObject    handle to StorageTexture (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns StorageTexture contents as cell array
%        contents{get(hObject,'Value')} returns selected item from StorageTexture


% --- Executes during object creation, after setting all properties.
function NativeTexture_CreateFcn(hObject, eventdata, handles)
% hObject    handle to NativeTexture (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in NativeTexture.
function NativeTexture_Callback(hObject, eventdata, handles)
% hObject    handle to NativeTexture (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns NativeTexture contents as cell array
%        contents{get(hObject,'Value')} returns selected item from NativeTexture
unit = get(handles.Units,'Value');
if unit ==1
    soilsdata=dlmread('soilsDNR.txt','\t',[0 1 10 4]);
else
    soilsdata=dlmread('soilsUS.txt','\t',[0 1 10 4]);
end
soilnumber = get(handles.NativeTexture,'Value');
set(handles.Ksat,'String',num2str(num2str(soilsdata(soilnumber,4))));



% --- Executes during object creation, after setting all properties.
function Kstore_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Kstore (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Kstore_Callback(hObject, eventdata, handles)
% hObject    handle to Kstore (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Kstore as text
%        str2double(get(hObject,'String')) returns contents of Kstore as a double


% --- Executes during object creation, after setting all properties.
function Kroot_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Kroot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Kroot_Callback(hObject, eventdata, handles)
% hObject    handle to Kroot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Kroot as text
%        str2double(get(hObject,'String')) returns contents of Kroot as a double


% --- Executes on button press in pushbutton3.
function pushbutton3_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object creation, after setting all properties.
function SMVol_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SMVol (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SMVol_Callback(hObject, eventdata, handles)
% hObject    handle to SMVol (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SMVol as text
%        str2double(get(hObject,'String')) returns contents of SMVol as a double


% --- Executes during object creation, after setting all properties.
function SMpercent_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SMpercent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SMpercent_Callback(hObject, eventdata, handles)
% hObject    handle to SMpercent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SMpercent as text
%        str2double(get(hObject,'String')) returns contents of SMpercent as a double


% --- Executes during object creation, after setting all properties.
function SMdepth_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SMdepth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SMdepth_Callback(hObject, eventdata, handles)
% hObject    handle to SMdepth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SMdepth as text
%        str2double(get(hObject,'String')) returns contents of SMdepth as a double


% --------------------------------------------------------------------
function Untitled_1_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_2_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object creation, after setting all properties.
function Stayper_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Stayper (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Stayper_Callback(hObject, eventdata, handles)
% hObject    handle to Stayper (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Stayper as text
%        str2double(get(hObject,'String')) returns contents of Stayper as a double


% --- Executes during object creation, after setting all properties.
function StayDpth_CreateFcn(hObject, eventdata, handles)
% hObject    handle to StayDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function StayDpth_Callback(hObject, eventdata, handles)
% hObject    handle to StayDpth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of StayDpth as text
%        str2double(get(hObject,'String')) returns contents of StayDpth as a double


% --- Executes on button press in Summary.
function Summary_Callback(hObject, eventdata, handles)
% hObject    handle to Summary (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Summary


% --- Executes on button press in Record.
function Record_Callback(hObject, eventdata, handles)
% hObject    handle to Record (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Record


% --- Executes during object creation, after setting all properties.
function edit67_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit67 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit67_Callback(hObject, eventdata, handles)
% hObject    handle to edit67 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit67 as text
%        str2double(get(hObject,'String')) returns contents of edit67 as a double


% --- Executes during object creation, after setting all properties.
function precip_CreateFcn(hObject, eventdata, handles)
% hObject    handle to precip (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function precip_Callback(hObject, eventdata, handles)
% hObject    handle to precip (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of precip as text
%        str2double(get(hObject,'String')) returns contents of precip as a double


% --- Executes during object creation, after setting all properties.
function SimType_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SimType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in SimType.
function SimType_Callback(hObject, eventdata, handles)
% hObject    handle to SimType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns SimType contents as cell array
%        contents{get(hObject,'Value')} returns selected item from SimType
Type = get(handles.SimType,'Value');
if Type == 2
    set(handles.PptType,'Visible','on'); set(handles.PptDepth,'Visible','on');; 
    set(handles.DepthLabel,'Visible','on');; set(handles.DistLabel,'Visible','on');;
    set(handles.PrecipLabel,'Visible','off');; set(handles.Input,'Visible','off');
    set(handles.LengthLabel,'Visible','off'); set(handles.Length,'Visible','off');
else
    set(handles.PptType,'Visible','off'); set(handles.PptDepth,'Visible','off'); 
    set(handles.DepthLabel,'Visible','off'); set(handles.DistLabel,'Visible','off');
    set(handles.PrecipLabel,'Visible','on'); set(handles.Input,'Visible','on');
    set(handles.LengthLabel,'Visible','on'); set(handles.Length,'Visible','on');    
end



% --- Executes during object creation, after setting all properties.
function PptType_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PptType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in PptType.
function PptType_Callback(hObject, eventdata, handles)
% hObject    handle to PptType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns PptType contents as cell array
%        contents{get(hObject,'Value')} returns selected item from PptType


% --- Executes during object creation, after setting all properties.
function PptDepth_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PptDepth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function PptDepth_Callback(hObject, eventdata, handles)
% hObject    handle to PptDepth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PptDepth as text
%        str2double(get(hObject,'String')) returns contents of PptDepth as a double


  


% --- Executes during object creation, after setting all properties.
function Units_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Units (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
prevunit=1;

% --- Executes on selection change in Units.
function Units_Callback(hObject, eventdata, handles)
% hObject    handle to Units (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns Units contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Units
C1 = 10.763910416709722573556258223628;  %m2 to ft2
C2 = 10.763910416709722573556258223628/43560;  %m2 to acre
C3 = 1/2.54;  %cm to in.
C4 = .0008107131937899125401845273267677; %m3 to acre-ft
%
B1 = 1/10.763910416709722573556258223628; %ft2 to m2
B2 = 4046.856422399999900285457752064;  %acre to m2
B3 = 2.54;  %in to cm
B4 = 1233.4818375475199544104; %acre-ft to m3

prevunit= get(handles.CurrentUnit,'Value');
unit = get(handles.Units,'Value');
if unit == prevunit
else
	if unit ==2 %convert Metric to English
        set(handles.Kroot,'String',num2str(str2num(get(handles.Kroot,'string'))*C3));
        set(handles.Kstore,'String',num2str(str2num(get(handles.Kstore,'string'))*C3));
        set(handles.Ksat,'String',num2str(str2num(get(handles.Ksat,'string'))*C3));
        set(handles.Sd,'String',num2str(str2num(get(handles.Sd,'string'))*C3));
        set(handles.Srz,'String',num2str(str2num(get(handles.Srz,'string'))*C3));
        set(handles.St,'String',num2str(str2num(get(handles.St,'string'))*C3));
        set(handles.UFlow,'String',num2str(str2num(get(handles.UFlow,'string'))*C3));
        set(handles.Udiam,'String',num2str(str2num(get(handles.Udiam,'string'))*C3/10));
        set(handles.AveET,'String',num2str(str2num(get(handles.AveET,'string'))*C3));
        set(handles.PptDepth,'String',num2str(str2num(get(handles.PptDepth,'string'))*C3));
        set(handles.BasinArea,'String',num2str(str2num(get(handles.BasinArea,'string'))*C2));
        set(handles.RGArea,'String',num2str(str2num(get(handles.RGArea,'string'))*C1));
        set(handles.Afunit1,'Visible','off');set(handles.Afunit2,'Visible','on');  
        set(handles.UDunit1,'Visible','off');set(handles.UDunit2,'Visible','on');  
        set(handles.Dpthunit1,'Visible','off');set(handles.Dpthunit2,'Visible','on');  
        set(handles.Atunit1,'Visible','off');set(handles.Atunit2,'Visible','on');  
        set(handles.Kunit1,'Visible','off');set(handles.Kunit2,'Visible','on');  
        set(handles.ETunit1,'Visible','off');set(handles.ETunit2,'Visible','on');  
        set(handles.Pptunit1,'Visible','off');set(handles.Pptunit2,'Visible','on');  
        set(handles.Tribunit1,'Visible','off');set(handles.Tribunit2,'Visible','on');  
        set(handles.Outunit1,'Visible','off');set(handles.Outunit2,'Visible','on');  
        set(handles.Usi,'Visible','off');set(handles.Uus,'Visible','on');  
        set(handles.text115,'Visible','off');set(handles.text114,'Visible','on');  
        set(handles.text116,'Visible','off');set(handles.text110,'Visible','on'); 
	else %Convert English to Metric
        set(handles.Kroot,'String',num2str(str2num(get(handles.Kroot,'string'))*B3));
        set(handles.Kstore,'String',num2str(str2num(get(handles.Kstore,'string'))*B3));
        set(handles.Ksat,'String',num2str(str2num(get(handles.Ksat,'string'))*B3));
        set(handles.Sd,'String',num2str(str2num(get(handles.Sd,'string'))*B3));
        set(handles.Srz,'String',num2str(str2num(get(handles.Srz,'string'))*B3));
        set(handles.St,'String',num2str(str2num(get(handles.St,'string'))*B3));
        set(handles.UFlow,'String',num2str(str2num(get(handles.UFlow,'string'))*B3));
        set(handles.Udiam,'String',num2str(str2num(get(handles.Udiam,'string'))*B3*10));
        set(handles.AveET,'String',num2str(str2num(get(handles.AveET,'string'))*B3));
        set(handles.PptDepth,'String',num2str(str2num(get(handles.PptDepth,'string'))*B3));
        set(handles.BasinArea,'String',num2str(str2num(get(handles.BasinArea,'string'))*B2));
        set(handles.RGArea,'String',num2str(str2num(get(handles.RGArea,'string'))*B1));
        set(handles.Afunit2,'Visible','off');set(handles.Afunit1,'Visible','on');  
        set(handles.UDunit2,'Visible','off');set(handles.UDunit1,'Visible','on');  
        set(handles.Dpthunit2,'Visible','off');set(handles.Dpthunit1,'Visible','on'); 
        set(handles.Atunit2,'Visible','off');set(handles.Atunit1,'Visible','on');  
        set(handles.Kunit2,'Visible','off');set(handles.Kunit1,'Visible','on');  
        set(handles.ETunit2,'Visible','off');set(handles.ETunit1,'Visible','on');  
        set(handles.Pptunit2,'Visible','off');set(handles.Pptunit1,'Visible','on');  
        set(handles.Tribunit2,'Visible','off');set(handles.Tribunit1,'Visible','on');  
        set(handles.Outunit2,'Visible','off');set(handles.Outunit1,'Visible','on');  
        set(handles.Uus,'Visible','off');set(handles.Usi,'Visible','on');  
        set(handles.text114,'Visible','off');set(handles.text115,'Visible','on'); 
        set(handles.text110,'Visible','off');set(handles.text116,'Visible','on'); 
	end
end
set(handles.CurrentUnit,'Value',unit);


% --- Executes during object creation, after setting all properties.
function CurrentUnit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to CurrentUnit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in CurrentUnit.
function CurrentUnit_Callback(hObject, eventdata, handles)
% hObject    handle to CurrentUnit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns CurrentUnit contents as cell array
%        contents{get(hObject,'Value')} returns selected item from CurrentUnit


% --- Executes on button press in Far.
function Far_Callback(hObject, eventdata, handles)
% hObject    handle to Far (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


unit = get(handles.Units,'Value');
 
for k = 1 : 2 
   

if k == 1
factors(1,:) = [0.01 0.05 .10 0.15 0.25];
else
factors(2,:) = new_factors;    
end


for i = 1:5
    
    f = factors(k,i);
 if unit ==2   
  Arg = str2num(get(handles.BasinArea,'String'))*43560*f %Bioretention Cell Size 
else
      Arg = str2num(get(handles.BasinArea,'String'))*f %Bioretention Cell Size 
  end

EIA = str2num(get(handles.ImpA,'String'));  %Percent impervious area
TribA = str2num(get(handles.BasinArea,'String'));  %Total Tributary Area
CN = str2num(get(handles.CN,'String'));
%g=9.8;		% acceleration of gravity [m/s2]
Sd=.35;		% depression storage in pervious area [cm]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% EVAPORATION PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
avet= str2num(get(handles.AveET,'String'));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SOIL SENSITIVITY PARAMETERS:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if unit ==1
    soilsdata=dlmread('soilsDNR.txt','\t',[0 1 10 4]);
else
    soilsdata=dlmread('soilsUS.txt','\t',[0 1 10 4]);
end
soilnames=textread('soilslist.txt','%s','delimiter','\n','whitespace','');
Nsoilnumber = get(handles.NativeTexture,'Value');
Rsoilnumber = get(handles.RootTexture,'Value');
Ssoilnumber = get(handles.StorageTexture,'Value');
NTexture = soilnames(Nsoilnumber,1);
STexture = soilnames(Ssoilnumber,1);
RTexture = soilnames(Rsoilnumber,1);
dmin = str2num(get(handles.Sd,'String'));
St = str2num(get(handles.St,'String'));  %Storage Zone thickness
Srz = str2num(get(handles.Srz,'String'));  %Root Zone thickness
Scz = 10;  %Default value for Control Zone thickness
Kcz= str2num(get(handles.Ksat,'String'));  %Control Zone Sat. Hydraulic Conductivity
Krz = str2num(get(handles.Kroot,'String'));  %Root Zone Sat. Hydraulic Conductivity
Kst = str2num(get(handles.Kstore,'String')); %Storage Zone Sat. Hydraulic Conductivity
if St==0    %Allow for no storage by dividing control zone into two equal layers
    St=5;  
    Scz=5;
    Kst = Kcz;
    STexture = NTexture;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  UNDERDRAIN SIZING
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Urate = str2num(get(handles.UFlow,'String'));
Umax = (Urate/100)*(Arg/3600); %Max. Underdrain flow [m3/sec]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MODELING PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% TEMPORAL:
HydroCalc = get(handles.SimType,'Value');  %1: Continuous, 2: Single Event, 3: User Type
if HydroCalc == 2
    rundays = 3;
else rundays = str2num(get(handles.Length,'String'));
end
time=rundays*24*60;			% min in data file
dt=15;						% TIME STEP [min]
stime=time/60;				% total time of simulation [h]
dt=dt/60;					% TIME STEP [h]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%DATAFILE RETRIEVAL
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
outname = get(handles.Output,'String');
Summary = get(handles.Summary,'Value');
Record = get(handles.Record,'Value');
fileext = '.txt';
if HydroCalc == 1
    filename = get(handles.Input,'String');
    infile = strcat(filename,fileext);
    nprecip=dlmread(infile,'\t',[1 0 ceil(stime)+1 2]);
    if unit ==1 
        nprecip(:,2)=nprecip(:,2)./10;      %convert Precip from [mm h-1] to [cm h-1]
        nprecip(:,3)=nprecip(:,3)./10;      %convert Evap from [mm h-1] to [cm h-1]
    else
    end
elseif HydroCalc == 2
    PptType = get(handles.PptType,'Value'); %1: Type I, 2: Type IA, 3: Type II, 4: Type III
    if PptType == 1
        PptName = 'TypeI';
    elseif PptType ==2 
        PptName = 'TypeIA'; 
    elseif PptType == 3 
        PptName = 'TypeII';
    else 
        PptName = 'TypeIII';
    end
    PptDepth = str2num(get(handles.PptDepth,'String'));
    PptFile = num2str(strcat(PptName,'.txt'));
    nprecip = dlmread(PptFile,'\t',[1 0 ceil(stime)+1 2]);
    nprecip(:,2)=nprecip(:,2).*PptDepth;      %convert Precip from [mm h-1] to [cm h-1]
    nprecip(:,3)=nprecip(:,3).*avet/24;      %convert Evap from [mm h-1] to [cm h-1]
else
    Sd = 0;  
    EIA = 100;
    filename = get(handles.Input,'String');
    infile = strcat(filename,fileext);
    nprecip=dlmread(infile,'\t',[1 0 ceil(stime)+1 2]);
    nprecip(:,2)=nprecip(:,2)./10;      %convert Precip from [mm h-1] to [cm h-1]
    nprecip(:,3)=nprecip(:,3)./10;      %convert Evap from [mm h-1] to [cm h-1]
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Run Modules
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if unit == 1
    [Dprecip,Dimp,Dperv,Drunon,Drunoff,Devap,Drecharge,Dudrain,Dstore,maxpond,tstponded,inot] = recarga(nprecip,Sd,avet,rundays,outname,Summary,Record,dmin,Srz,St,Rsoilnumber,Ssoilnumber,Nsoilnumber,Krz,Kst,Kcz,Urate,CN,EIA,Arg,TribA);
else
    nprecip(:,2)=nprecip(:,2).*2.54; nprecip(:,3)=nprecip(:,3).*2.54;
    [Dprecip,Dimp,Dperv,Drunon,Drunoff,Devap,Drecharge,Dudrain,Dstore,maxpond,tstponded,inot] = recarga_us(nprecip,Sd,avet,rundays,outname,Summary,Record,dmin,Srz,St,Rsoilnumber,Ssoilnumber,Nsoilnumber,Krz,Kst,Kcz,Urate,CN,EIA,Arg,TribA);
end
Dstay(k,i) = Dprecip - Drunoff- Dudrain

if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Fit Stayon and factor to an exponential curve
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if k == 1
if unit ==2
idx(k,:) = find(abs(Dstay(k,:)-Dprecip)>.0001);

lnfactors = log(factors(idx(k,:)));
fit = [Dstay(idx(k,:))' ones(size(idx(k,:),2),1)] \ lnfactors';
b(k) = fit(1)
a(k) = exp(fit(2))


in = str2num(get(handles.target_stayon,'String'));
out(k) = (a(k)*exp(b(k)*in))
if out(k)>.02
new_factors = [out(1) out(1)-0.02 out(1)+0.02 out(1)-0.01 out(1)+0.01];
else
    new_factors = [out(1) out(1)+0.01 out(1)+0.02 out(1)+0.03 out(1)+0.04];
end
    
axes(handles.axes9)
plot(Dstay(k,:), (factors*100))

else

idx(k,:) = find(abs(Dstay(k,:)-Dprecip)>.0001);

lnfactors = log(factors(idx(k,:)));
fit = [((Dstay(idx(k,:)))/2.54)' ones(size(idx(k,:),2),1)] \ lnfactors';
b(k) = fit(1)
a(k) = exp(fit(2))


in = str2num(get(handles.target_stayon,'String'));
out(k) = (a(k)*exp(b(k)*(in/2.54)))
if out(k)>.02
new_factors = [out(1) out(1)-0.02 out(1)+0.02 out(1)-0.01 out(1)+0.01];
else
    new_factors = [out(1) out(1)+0.01 out(1)+0.02 out(1)+0.03 out(1)+0.04];
end
new_factors = [out(1) out(1)-0.02 out(1)+0.02 out(1)-0.01 out(1)+0.01];
axes(handles.axes9)
plot(Dstay(k,:), (factors*100))


end



else
if unit ==2
idx2(k,:) = find((Dstay(2,:)));   
lnfactors2 = log(factors(2,:));
fit = [((Dstay(2,:)))' ones(size(idx2,2),1)] \ lnfactors2';

b = fit(1)
a = exp(fit(2))
in = str2num(get(handles.target_stayon,'String'));
out(2) = 100*(a*exp(b*(in)));

else
idx2(k,:) = find((Dstay(2,:)));   
lnfactors2 = log(factors(2,:));
fit = [((Dstay(2,:))/2.54)' ones(size(idx2,2),1)] \ lnfactors2';

b = fit(1)
a = exp(fit(2))
in = str2num(get(handles.target_stayon,'String'));
out(2) = 100*(a*exp(b*(in/2.54)));










end

end

end

   
set(handles.Estimate_FAR,'String',num2str(out(2)));

% --- Executes during object creation, after setting all properties.
function target_stayon_CreateFcn(hObject, eventdata, handles)
% hObject    handle to target_stayon (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function target_stayon_Callback(hObject, eventdata, handles)
% hObject    handle to target_stayon (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of target_stayon as text
%        str2double(get(hObject,'String')) returns contents of target_stayon as a double


% --- Executes during object creation, after setting all properties.
function Estimate_FAR_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Estimate_FAR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Estimate_FAR_Callback(hObject, eventdata, handles)
% hObject    handle to Estimate_FAR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Estimate_FAR as text
%        str2double(get(hObject,'String')) returns contents of Estimate_FAR as a double


% --- Executes during object creation, after setting all properties.
function axes5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to axes5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate axes5


% --- Executes during object creation, after setting all properties.
function axes9_CreateFcn(hObject, eventdata, handles)
% hObject    handle to axes9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate axes9


