function Mcap=DTHDH(h,a,nn,nsat,nres,ss,hh0);
%
% DTHDH.M - Calculates the specific moisture capacity as a function
%    of pressure head. Reference: van Genuchten, M. T. 1980. A 
%    closed-form equation for predicting the hydraulic conductivity 
%    of unsaturated soils. Soil Sci. Soc. Amer. J. 44, 892-898.
% INPUT: h (pressure head), a (van Genuchten paramater alpha), nn (van
%		Genuchten n), nsat (saturation water content), nres (residual)
% OUTPUT: moisture capacity [0,x]
%
%p=-h;		% use positive numbers for relation
%p=p-1/a/2;    % correct for air-entry suction=1/a
%if p<0; p=0; end;        % check for positive pressure heads
% thus, function will return M=0 for saturated conditions
%x=p>0;
%p=x.*p; % sets p=0 where pi=-hi<0
x=h>hh0;    % ones where hi>hh0
mm=1-(1/nn);
% threl=(1./(1+(a.*p).^nn)).^mm;		% >=0 and <=1
% b=a*(nn-1)*(nsat-nres);					% >0
% c=(1-threl.^(1/mm)).^mm;				% >=0
% Mcap=b*(threl.^(1/mm)).*c;		 % dthdh>=0 (dthdp<=0)
b=a^nn*(nn-1)*(nsat-nres);					% >0
c=(1+(-a.*h).^nn).^(mm+1);
Mcap=(1-x).*(b*abs(h).^(nn-1)./c)+x.*ss;		 % dthdh>0